# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
import sys
from datetime import datetime
import libra
import urllib
import random, re


TRANSLATION = None


def build_translation():
    global TRANSLATION
    if TRANSLATION is None:
        import sys
        import unicodedata
        TRANSLATION = {
            index: u' ' for index in xrange(sys.maxunicode)
            if unicodedata.category(unichr(index)).startswith('P')
        }
        for char in u'\t\n\x0b\x0c\r$+<=>^`|~':
            TRANSLATION[ord(char)] = u' '
    return TRANSLATION


def normalize_query(query):

    try:
        query = query.decode('utf8')
    except UnicodeDecodeError:
        return

    query = query.translate(build_translation())
    query = query.lower()
    query = query.strip()
    query = re.sub(r'\s\s+', ' ', query)

    return query.encode('utf8')


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '20115'
    e1 = '20116'
    e2 = '20117'
    e3 = '20118'

    for r in s:
        if not r.IsA("TTouchYandexWebRequest"):
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        if r.HasTestID(c):
            slot = 'control ' + c
        elif r.HasTestID(e1):
            slot = 'exp ' + e1
        elif r.HasTestID(e2):
            slot = 'exp ' + e2
        elif r.HasTestID(e3):
            slot = 'exp ' + e3
        else:
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        for cl in r.GetClicks():
            p = cl.ConvertedPath
            url = str(cl.Url)
            if ('http://www.labirint.ru/books/' in url and not url.endswith('/books/')) or ('http://read.ru/id/' in url and not url.endswith('id/')) or ('http://www.litres.ru/' in url and not url.endswith('litres.ru/')) or ('http://www.bookvoed.ru/book?id=' in url and not url.endswith('?id=')) or ('http://my-shop.ru/shop/books/' in url and '.html' in url) or ('http://mdk-arbat.ru/bookcard?book_id=' in url and not url.endswith('?book_id=')) or ('http://www.books.ru/books/' in url and not url.endswith('/books/')) or ('http://www.chitai-gorod.ru/catalog/book/' in url and not url.endswith('/book/')) or ('http://www.libex.ru/detail/' in url and '.html' in url) or ('http://www.sprinter.ru/shop/goods/' in url and not url.endswith('/goods/')) or ('http://www.biblion.ru/product/' in url and not url.endswith('/product')) or ('http://www.moscowbooks.ru/book.asp?id=' in url and not url.endswith('?id=')) or ('http://www.booka.ru/books/' in url and not url.endswith('/books/')) or ('http://www.bookmg.ru/product/' in url and not url.endswith('/product/')):
                yield Record(uid,'',slot + '\t' + ts + '\t' + p + '\t' + url)


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['16','17','18','19','20','21','22','23','24','25','26','27','28','29']
    for d in dd:
        src = 'user_sessions/201601' + d
        dt0 = 'ensuetina/RO/new_exp'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTable = dt0,
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )


if __name__ == '__main__':
    main()
