# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random
import urlparse

TRANSLATION = None

def build_translation():
    global TRANSLATION
    if TRANSLATION is None:
        import sys
        import unicodedata
        TRANSLATION = {
            index: u' ' for index in xrange(sys.maxunicode)
            if unicodedata.category(unichr(index)).startswith('P')
        }
        for char in u'\t\n\x0b\x0c\r$+<=>^`|~':
            TRANSLATION[ord(char)] = u' '
    return TRANSLATION


def normalize_query(query):

    try:
        query = query.decode('utf8')
    except UnicodeDecodeError:
        return

    query = query.translate(build_translation())
    query = query.lower()
    query = query.strip()
    query = re.sub(r'\s\s+', ' ', query)

    return query.encode('utf8')


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    start_dict = ['как '] # слова, с которых может начинаться запрос
    markers = ['смотреть', 'видео', 'фильм', 'мультфильм', 'сериал', 'музыка', 'клип', 'песня', 'своими руками', 'инструкци', 'кино', 'прохожден', 'сезон', 'прикол', 'серия', 'ютуб', 'youtube', 'мультик', 'своими руками', 'обзор', 'видеообзор', 'видеоурок', 'рецепт'] # слова, которые может содержать запрос
    end_dict = [] # слова, которыми может заканчиваться запрос

    stop_words = [] # stop words


    for r in s:
#        if r.IsA('TTouchYandexWebRequest'):
#            ui = 'Touch'
#        elif r.IsA('TPadYandexWebRequest'):
#            ui = 'Tablet'
        if r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        q = normalize_query(r.Query) # получаем запрос

        if len(q) == 0:
            continue

        isStop = 0
        for word in stop_words: # проверяем на стоп-слова
            if word in q:
                isStop = 1
                break

        if isStop == 1: # если было стоп-слово, переходим к следующему запросу
            continue

        isStart = 0
        isMarker = 0
        isEnd = 0

        start_word = ''
        marker_word = ''
        end_word = ''

        for word in start_dict: # проверяем на первые слова
            if q.startswith(word):
                isStart = 1
                start_word = word
                break

        for word in markers: # проверяем на содержание слов
            if word in q:
                isMarker = 1
                marker_word = word
                break

        for word in end_dict: # проверяем на последние слова
            if q.endswith(word):
                isEnd = 1
                end_word = word
                break

        if isStart + isEnd + isMarker == 0: # если ни одно из правил не выполнилось, переходим к следующему запросу
            continue

        i = 0
        for bl in r.GetMainBlocks(): # если какое-то из правил выполнилось, обходим первые 10 результатов выдачи и сохраняем хосты органики
            m = bl.GetMainResult()
            if m.IsA('TWebResult'): # проверяем, что это органика
                url = str(m.Url)
                host = urlparse.urlparse(url).netloc
                yield Record(str(host),'',ts + '\t' + q + '\t' + str(isStart) + '\t' + str(isMarker) + '\t' + str(isEnd) + '\t' + start_word + '\t' + marker_word + '\t' + end_word, tableIndex = 0) # hosts

            if i > 10:
                break

            i += 1

        yield Record(q,'','', tableIndex = 1) # requests

# агрегация. в ключе входной таблицы должно лежать поле, по которому хотим агрегировать
def aggr(key,recs):
    i = 0
    for rec in recs: # считаем частоту поля в ключе
        i += 1

#    if i < 5: # если частота меньше некоторого числа, можем запись пропустить. Это бывает нужно для отрезания хвостов
#        return

    yield Record(key,'',str(i)) # сохраняем ключ и его частоту

def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'tmp',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )
    username = 'ensuetina'
    start = '20160205'
    end = '20160205'

    cur_d1 = datetime.strptime(start, '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')

    # в цикле по дням собираем данные из логов
    while int(cur_d) <= int(end):

        print cur_d
        src = 'sample_by_yuid_1p/user_sessions/' + cur_d # 1% лог
        #src = 'user_sessions/' + cur_d # если хочется запустить по полному логу

        dt0 = username + '/VIDEO_TRY/hosts'
        dt1 = username + '/VIDEO_TRY/requests'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            #appendMode = True, # если надо проитерироваться по нескольким дням и дописывать данные в одну таблицу. Если appendMode не стоит, данные будут перезаписываться
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)
        cur_d = str(cur_d1).replace('-','')


    # после того, как собрали данные, агрегируем их
    MapReduce.runReduce(aggr,
                        srcTable = dt0,
                        dstTable = dt0 + '_aggr',
                        sortMode = True
                       )

    MapReduce.runReduce(aggr,
                        srcTable = dt1,
                        dstTable = dt1 + '_aggr',
                        sortMode = True
                       )


if __name__ == '__main__':
    main()
