# -*- coding: UTF-8 -*-

from datetime import datetime, timedelta, date
from nile import(
    clusters,
    Record,
    filters as nf,
    aggregators as na
)
import nile
import uatraits, libra

def Reduce(groups):
    detector = uatraits.detector('/usr/share/uatraits/browser.xml')
    for key, records in groups:
        uid = key.key
        #if uid[0] != 'y':
        #    continue

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TTouchYandexWebRequest'):
                ui = 'Touch'
            else:
                continue

            if r.ServiceDomRegion != 'ru':
                continue

            ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

            SPL = 0
            for tech in r.GetYandexTechEvents(): # вычисляем высоту колдунщика и элемента под ним, это пишется в счетчик serp.page.loaded в vars: -res-heights
                if not tech.IsA('TYandexTechEvent'):
                    continue
                p = tech.Path
                if '471.143.1007' in p or 'serp.page.loaded' in p:
                    SPL = 1
                    break

            smartbanner = 0
            for bl in r.GetBSBlocks():
                p = bl.Path
                if 'smartbanner/' in p:
                    smartbanner = 1
                    break

            spv = r.SearchPropsValues
            spv_smb = ''
            for k in spv.keys():
                if 'REPORT.smartbanner' in k:
                    spv_smb = k + '=' + str(spv[k])

            sm_clicks = 0
            for cl in r.GetClicks():
                p = cl.ConvertedPath
                if 'smartbanner/' in p:
                    sm_clicks = 1
                    break

            if (sm_clicks + len(spv_smb) ) > 0 and smartbanner == 0:

#            if SPL == 0:
                reqid = r.ReqID
                bsb_len = len(r.GetBSBlocks())
                ua = r.UserAgent

                if ua:
                    d = detector.detect(ua)
                else:
                    d = {}

                Device = ' '
                BR = ' '
                OS = ' '
                OSF = ' '
                BV = ' '

                if 'OSName' in d:
                    OS = d['OSName']
                if 'OSFamily' in d:
                    OSF = d['OSFamily']
                if 'DeviceName' in d:
                    Device = d['DeviceName']
                if 'BrowserName' in d:
                    BR = d['BrowserName']
                if 'BrowserVersion' in d:
                    BV = d['BrowserVersion']

                ref = str(r.Referer).split('?')[0]

                yield Record(uid=uid,ts=ts,reqid=reqid,bsb_len=bsb_len,ref=ref,OS=OS,BR=BR,BV=BV,Device=Device,SPL=SPL,smartbanner=smartbanner,sm_clicks=sm_clicks,spv_smb=spv_smb)
#                yield Record(uid=uid,ts=ts,smartbanner=smartbanner)


username = 'ensuetina'
cluster = clusters.Plato().env(
                                job_root=('home/search-research/' + username + '/nile/COUNTERS_TROUBLES/1') # directory on plato where i plan to store results
                              )
dates = nile.api.path.DateRange('20160212', '20160212')
for date in dates:
    job = cluster.job().env(date=date)

    log = job.table('userdata/user_sessions/$date')

    queries = log.groupby('key').sort('subkey').reduce(Reduce,files=[nile.files.LocalFile('blockstat.dict'),nile.files.LocalFile('libra.so')]).put('$job_root/result_smb')

    job.run()

