# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return


    for r in s:
        if r.IsA('TTouchYandexWebRequest'):
            ui = 'Touch'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        SPL = 0
        for tech in r.GetYandexTechEvents(): # вычисляем высоту колдунщика и элемента под ним, это пишется в счетчик serp.page.loaded в vars: -res-heights
            if not tech.IsA('TYandexTechEvent'):
                continue
            p = tech.Path
            if '471.143.1007' in p or 'serp.page.loaded' in p:
                SPL = 1
                break

        if SPL == 0:
            reqid = r.ReqID
            bsb_len = len(r.GetBSBlocks())
            ua = r.UserAgent
            ref = str(r.Referer).split('?')[0]
            yield Record(uid,'',ts + '\t' + str(reqid) + '\t' + str(ua) + '\t' + str(bsb_len) + '\t' + str(ref))



def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    cur_d1 = datetime.strptime('20160212', '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')
    while int(cur_d)<int(20160213):

        print cur_d
        src = 'user_sessions/' + cur_d

        dt = 'ensuetina/COUNTERS_TROUBLES/data'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTable = dt,
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            #appendMode = True,
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)

        cur_d = str(cur_d1).replace('-','')


if __name__ == '__main__':
    main()
