# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return


    for r in s:
        if r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        for cl in r.GetClicks():
            p = cl.ConvertedPath
#            if '/popup_close' in p and ('footer/' in p or 'stripe/inline' in p):
#                yield Record(uid,'',p)
#            if 'wiz/default_search/error' in p:
#                vv = str(cl.GetVars())
#                if 'userCancelled' in vv:
            if '/install' in p and ('wiz/default_search' in p or 'stripe/inline' in p or 'footer/' in p):
                    yield Record(uid,'',ts + '\t' + p)



def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['0129','0130','0131','0201','0202','0203','0204','0205','0206','0207','0208','0209','0210','0211','0212']
    for d in dd:

        src = 'user_sessions/2016' + d

        dst = 'ensuetina/LTV_CANCELES/installs'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTable = dst,
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                           )



if __name__ == '__main__':
    main()
