# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    c = '20623'
    exps = ['20625','20630','20631','20676']

    for r in s:
        if r.IsA('TPadYandexWebRequest'):
            ui = 'Tablet'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        slot = ''
        if r.HasTestID(c):
            slot = 'control ' + c
        else:
            for e in exps:
                if r.HasTestID(e):
                    slot = 'exp ' + e

        if len(slot) == 0:
            continue

        isOA = 0
        for bl in r.GetBSBlocks():
            p = bl.Path
            if 'parallel/object-answer' in p:
                isOA = 1
                break

        if isOA == 1:
            yield Record(uid + '\t' + slot,'','')

def aggr(key,recs):
    k = key.split('\t')
    yield Record(k[0],'',k[1])


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    cur_d1 = datetime.strptime('20160206', '%Y%m%d')
    cur_d1 = cur_d1.date()

    cur_d = str(cur_d1).replace('-','')
    while int(cur_d)<int(20160217):

        print cur_d
        src = 'user_sessions/' + cur_d

        dt = 'ensuetina/PADS_OA/OA_shows'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTable = dt,
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )

        cur_d1 = cur_d1 + timedelta(days=1)

        cur_d = str(cur_d1).replace('-','')

    MapReduce.runReduce(aggr,
                        srcTable = dt,
                        dstTable = dt + '_aggr',
                        sortMode = True
                       )


if __name__ == '__main__':
    main()
