#-*-coding: utf8 -*-

from nile import (
    clusters,
    Record,
    filters as nf,
    aggregators as na
)
import nile
import uatraits, libra

import urlparse

def Reduce(groups):
    shop = ['market.yandex.ru/', 'eldorado.ru/', 'sotmarket.ru/', 'dns-shop.ru/', 'wildberries.ru/', 'ru.aliexpress.com/', 'samsung.com/', 'mvideo.ru/', 'svyaznoy.ru/', 'ikea.com/', 'livemaster.ru/', 'ulmart.ru/', 'ebay.com/', 'ozon.ru/', 'labirint.ru/', 'lokata.ru/', 'nadavi.ru/', 'rozetka.com.ua/', 'citilink.ru/', 'sportmaster.ru/', 'aliexpress.com/', 'torg.mail.ru/', 'detmir.ru/', 'apple.com/', 'mobiguru.ru/', 'vseinstrumenti.ru/', 'euroset.ru/', 'lamoda.ru/', 'nix.ru/', 'e96.ru/', 'moskva.beeline.ru/', 'hotline.ua/', 'leroymerlin.ru/', 'enter.ru/', 'kidstaff.com.ua/', 'price.ua/', 'mobilluck.com.ua/', 'e5.ru/', 'molotok.ru/', '100sp.ru/', 'sima-land.ru/', 'ru.oriflame.com/', 'allo.ua/', 'adidas.ru/', 'gloria-jeans.ru/', 'migom.by/', 'bt.rozetka.com.ua/', 'price.ru/', 'bonprix.ru/', 'comfy.ua/', 'biglion.ru/', 'electro-mpo.ru/', 'shop.by/', 'kupivip.ru/', '5element.by/', 'avon.ru/', 'santehnika-online.ru/', 'market.yandex.ua/', 'otto.ru/', 'quelle.ru/', 'faberlic.com/', 'sitepokupok.ru/', 'market.mediamarkt.ru/', 'bonprix.ua/', 'rutaobao.com/', 'emarket.ua/', 'decathlon.ru/', 'hard.rozetka.com.ua/', 'velcom.by/', 'ua.oriflame.com/', 'wildberries.by/', 'oz.by/', 'vsemayki.ru/', 'pulscen.ru/', 'bay.ru/', 'mnogomebeli.com/', 'tinydeal.com/', 'sp.tomica.ru/', 'by.oriflame.com/', 'laredoute.ru/', 'odezhda-master.ru/', 'baraholka.onliner.by/', 'rus.nextdirect.com/', 'laguna.by/', '21vek.by/', 'modnakasta.ua/', 'aport.ru/', 'megatop.by/', 'market.yandex.by/', 'allegro.pl/', 'leboutique.com/', 'avon.com.ua/', 'coca-cola.ru/', 'moda.aukro.ua/', 'group.aliexpress.com/', '24moda.by/', 'lamoda.ua/', 'faberlic.by/', 'krivoyrog.dnp.olx.ua/', 'ua.nextdirect.com/', 'mobile.aukro.ua/', 'search.eim.ebay.ru/', 'login.aliexpress.com/', 'lk.wildberries.ru/', 'lk.wildberries.by/', 'activities.aliexpress.com/', 'shoppingcart.aliexpress.com/', 'ssl.aukro.ua/', 'us.ae.aliexpress.com/', 'my.aliexpress.com/', 'trade.aliexpress.com/', 'trade.alibaba.com/']

    bull = ['avito.ru/', 'irr.ru/', 'prom.ua/', 'moyareklama.ru/', 'tiu.ru/', 'ru.trovit.com/', 'dmir.ru/', 'slando.ua/', 'spb.pulscen.ru/', 'aukro.ua/', 'kufar.by/', 'krsk.24au.ru/', 'vladivostok.farpost.ru/', 'second.by/', 'bazarpnz.ru/', 'slando.ru/', 'kiev.ko.slando.ua/', 'ivbb.ru/', 'irr.by/', 'unibo.ru/', 'kharkov.kha.slando.ua/', 'torg.ua/', 'odessa.od.slando.ua/', 'dnepropetrovsk.dnp.slando.ua/', 'donetsk.don.slando.ua/', 'ay.by/', 'moyareklama.by/', 'olx.ua/', 'krivoyrog.dnp.slando.ua/', 'vitebsk.irr.by/', 'spec.drom.ru/', 'moskva.msk.slando.ru/', 'sankt-peterburg.len.slando.ru/', 'm.avito.ru/', 'barahla.net/', 'minsk.mn.olx.by/', 'auction.violity.com/', 'kiev.ko.olx.ua/', 'kharkov.kha.olx.ua/', 'dnepropetrovsk.dnp.olx.ua/', 'zaporozhe.zap.olx.ua/', 'odessa.od.olx.ua/', 'donetsk.don.olx.ua/', 'nikolaev.nik.olx.ua/', 'klubok.com/', 'www2.kufar.by/', 'inclk.com/', 'remote5.lib.wm-panel.com/']

    auto = ['drive2.ru/', 'auto.ru/', 'forums.drom.ru/', 'auto.mail.ru/', 'drom.ru/', 'avto-russia.ru/', 'avtomarket.ru/', 'automn.ru/', 'rst.ua/', 'exist.ru/', 'reviews.drom.ru/', 'gibdd.ru/', 'auto.drom.ru/', 'auto.ria.ua/', 'auto.ria.com/', 'auto.ironhorse.ru/', 'carsguru.net/', 'cars.auto.ru/', 'autolada.ru/', 'moscow.auto.ru/', 'bmwpost.ru/', 'pddmaster.ru/', 'avtobazar.ua/', 'abw.by/', 'cars.ru/', 'auto.yandex.ru/', 'av.by/', 'quto.ru/', 'novosibirsk.drom.ru/', '24auto.ru/', 'pddrussia.com/', 'zr.ru/', 'drive.ru/', 'audi-club.ru/', 'wroom.ru/', 'ffclub.ru/', 'cars.mail.ru/', 'bibika.ru/', 'am.ru/', 'forum.auto.ru/', 'auto.e1.ru/', 'barnaul.drom.ru/', 'carpis.ru/', 'omsk.drom.ru/', 'moto.auto.ru/', 'irkutsk.drom.ru/', 'autorambler.ru/', 'autochel.ru/', 'vladivostok.drom.ru/', 'avtobazar.infocar.ua/', 'tyumen.drom.ru/', 'chita.drom.ru/', 'moscow.drom.ru/', 'kemerovo.drom.ru/', 'myauto.by/', 'habarovsk.drom.ru/', 'trucks.auto.ru/', 'pravo.av.by/', 'pdd.by/', 'auto.onliner.by/', 'auto.tut.by/', 'exist.by/', 'zarulem.by/', 'otomoto.pl/', 'suchen.mobile.de/', 'ab.onliner.by/', 'elcats.ru/', 'auto.aukro.ua/', 'new.auto.ru/', 'all.auto.ru/', 'auto.d10.ru/']

    for key, records in groups:
        uid = key.key
        #if uid[0] != 'y':
        #    continue

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TTouchYandexWebRequest'):
                ui = 'TOUCH'
            else:
                continue

            for bl in r.GetMainBlocks():
                isH = 0
                m = bl.GetMainResult()
                if m.IsA('TWebResult'):
                    url = str(m.Url)
                    for host in shop:
                        if (url.startswith(host) or url.startswith('http://' + host) or url.startswith('http://www.' + host) or url.startswith('https://' + host) or url.startswith('https://www.' + host) or url.startswith('www.' + host)) and not url.endswith(host):
                            isH = 1
                            yield Record(url=url,host=host,htype='shop')

                    if isH == 1:
                        continue

                    for host in bull:
                        if (url.startswith(host) or url.startswith('http://' + host) or url.startswith('http://www.' + host) or url.startswith('https://' + host) or url.startswith('https://www.' + host) or url.startswith('www.' + host)) and not url.endswith(host):
                            isH = 1
                            yield Record(url=url,host=host,htype='bulletin')

                    if isH == 1:
                        continue

                    for host in auto:
                        if (url.startswith(host) or url.startswith('http://' + host) or url.startswith('http://www.' + host) or url.startswith('https://' + host) or url.startswith('https://www.' + host) or url.startswith('www.' + host)) and not url.endswith(host):
                            isH = 1
                            yield Record(url=url,host=host,htype='auto')


username = 'ensuetina'
cluster = clusters.YT(proxy="hahn.yt.yandex.net").env(
                                                        job_root=('home/search-research/ensuetina/TOP_HOSTS')
                            )

job = cluster.job()

log = job.table('user_sessions/pub/search/daily/2016-03-01/clean')

hosts = log.groupby('key').sort('subkey').reduce(Reduce,files=[nile.files.LocalFile('blockstat.dict'),nile.files.LocalFile('libra.so')]).put('$job_root/result')

#hosts = job.table('$job_root/result')

hosts.groupby('url','host','htype').aggregate(freq=na.count()).put('$job_root/aggr')


#    aggr_queries = queries.groupby('query').aggregate(freq=aggregators.count()).put('$job_root/queries')

#    filtered_queries = aggr_queries.filter(
#                        nf.custom(lambda x: x > 1000, 'freq')
#                   ).put('$job_root/queries_freq_more_1K') # filtering freq > 1000 and store filtered table


#    join1 = tr.join(filtered_queries, by='query').filter( nf.custom(bool, 'freq')).put('$job_root/join1') # join table of hosts with table of queries
job.run()

