# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random

TRANSLATION = None

def build_translation():
    global TRANSLATION
    if TRANSLATION is None:
        import sys
        import unicodedata
        TRANSLATION = {
            index: u' ' for index in xrange(sys.maxunicode)
            if unicodedata.category(unichr(index)).startswith('P')
        }
        for char in u'\t\n\x0b\x0c\r$+<=>^`|~':
            TRANSLATION[ord(char)] = u' '
    return TRANSLATION


def normalize_query(query):

    try:
        query = query.decode('utf8')
    except UnicodeDecodeError:
        return

    query = query.translate(build_translation())
    query = query.lower()
    query = query.strip()
    query = re.sub(r'\s\s+', ' ', query)

    return query.encode('utf8')


def Reduce(key, recs):
    uid = key
    if uid[0] != 'y':
        return

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return

    hosts = ['caniplay.ru','cosmicgames.ru','datgame.ru','gameboy10.ru','game-forboys.ru','gamesonlines.ru','igry-dlya-devochec.ru','igry-man.net','multoigri.ru','playshake.ru','1001guru.ru','flashgames.ru','gameee.ru','girlsgogames.ru','ourgames.ru']

    markers = ['игры', 'biggame', 'играть', 'игра', ' портал солнышко ', ' твиди ', ' солнет ', ' livegames ', ' на куличках ', 'подсолнушки', 'babyuser', 'a10 com', 'букабук', 'bukabuk', 'карос', 'karos', '11х11', 'севелина', ' степанида ', 'гонки на машинах', 'гонки онлайн', 'онлайн гонки', 'войнушки', 'раскраски', 'пазлы онлайн', 'онлайн пазлы', 'одевалки', 'бродилки', 'ходилки', 'переодевалки', 'рисовалки', 'рисовать онлайн', 'квесты', 'аркады', ' шарики ', 'шарики онлайн', 'онлайн шарики', ' линии ', 'линии онлайн', 'онлайн линии', 'пасьянсы онлайн', 'онлайн пасьянсы', '1000 онлайн', 'онлайн 1000', 'дурак онлайн', 'онлайн дурак', 'пасьянс паук', 'пасьянс пирамида', 'пасьянс косынка', 'пасьянс тысяча', 'паук онлайн', 'пирамида онлайн', 'косынка онлайн', 'тысяча онлайн', 'покер онлайн', 'бильярд онлайн', 'онлайн бильярд', 'шахматы онлайн', 'онлайн шахматы', 'шашки онлайн', 'онлайн шашки', 'крестики нолики', 'морской бой', 'судоку онлайн', 'онлайн судоку', 'bubble shooter', 'бабл шутер', ' алхимия ', ' червячки ', ' алхимик ', ' акинатор ', 'как достать соседа', ' маджонг ', 'маджонг онлайн', 'онлайн маджонг', ' танки ', 'танки онлайн', 'раскраска', 'гонки на', 'стрелялки', 'алавар', 'doodle jump', 'дудл джамп', 'квест', 'рисовалка', 'одевалка', 'buhs', 'buhf', 'игр', 'майнкрогонь и вода', 'винкс', 'монстр хай']

    stop_words = ['шерлок холмс', 'престолов', 'игра на выживание', 'голодные игры', 'олимпийские игры', 'игры разума', 'игры киллеров', 'сериал', 'фильм', 'игра с огнем', 'игры богов', 'подвижные игры', 'для компании', 'в компании', 'для веселой компании', 'правила игры', 'шпионские игры', 'игры в которые играют люди', 'деловые игры', 'ролевые игры порно', 'ролевые порно игры', 'игры ролевые порно', 'игры порно ролевые', 'порно игры ролевые', 'порно ролевые игры', 'на гитаре', 'гитара', 'жестокие игры', 'журнал', 'осмотра', 'медосмотра', 'службы', 'медкомиссии', 'комиссии', 'прохождение маточных труб', 'техосмотра', 'женщины в игре', 'любовь не игрушки', 'контригра', 'нюрнберг контригра', 'криминальные игры', 'смертельные игры', 'большая игра', 'взрослые игры', 'игрок', 'игра без правил', 'игра на выбывание', 'игрушки', 'игры в подкидного', 'короли игры', 'сезон', 'вне игры', 'финал', 'сезона', 'финала', 'первая игра', 'вторая игра', 'вхл', 'плей офф', 'счёт', 'счет', 'расписание', 'высоцкий', 'квн', 'теория игр', 'магазин игр', 'статья', 'двойная игра', 'деловая игра', 'дидактические игры', 'дикие игры', 'динамо', 'олимпийских', 'длительность игры', 'игра наоборот', 'игры уголовников', 'на день рождения', 'доклад', 'музыкальном инструменте', 'миллиардер конец игры', 'жестокая игра', 'жизнь игра', 'жириновский', 'жистокие игры', 'пианино', 'забавные игры', 'на природе', 'заброшенные доты', 'задача', 'застольные', 'зенит', 'зимние игры', 'народные игры', 'народная игра', ' значение', 'forex', 'иллюстрация', 'иллюстрации', 'игра об уильяме шекспире', 'кино', 'триллер', 'параолимпийские', 'параолимпийских', 'интеллектуальные', 'интернет магазин', 'дидактических игр', ' использование', 'исследовательская работа', 'товарищеских', 'товарищеская', 'играть песню', 'как называется игра', 'как научиться играть', 'как отучить', 'какую роль', 'календарь игр', 'картинки раскраски', 'картотека игр', 'картотека дидактических игр', 'раскраски', 'раскраска', ' классификация', 'клуб веселых и находчивых', 'когда будут играть', 'командная игра', 'командные игры', ' конспект', ' консультация', 'корпоративные игры', 'корпоративная игра', 'коррекционные игры', 'профилактические игры', ' кубок', ' курсовая', 'курс игры', 'кхл', 'лига чемпионов', 'лингвистические игры', 'линейка беременности', 'линейка авто', 'линейка в школе', 'линейка для измерения', 'линейка для замера', 'линейка для определен', 'линейка для пэчворка', 'линейка для проверки', 'линейка измерительная', 'линейка металлическая', 'литературная игра', 'логопедическая', 'логопедические', 'люди которые играют в игры', 'люди сообщества игры музыка', ' магазин biggame', ' магазин игр', ' магазин настольных игр', 'массовые игры', 'матричные игры', 'мгуту', ' методика', ' методики', ' методическ', 'музыка для', ' мультфильмы', 'народные игры', 'настольная игра', 'настольные игры', 'ноты для', ' ноутбук', ' ооо biggame', 'педагогические игры', 'педагогическая игра', ' песни biggame', ' песня biggame', ' победители', ' последняя игра', ' правила', ' презентация', ' примеры', ' приёмы игры', ' проведение', 'конкурсы', ' результат игр', ' результаты игр', ' реферат', ' самоучитель игры', ' сборная', ' своя игра', ' смотреть игр', ' смотреть мульт', 'игра теней', ' содержание', ' согласие на', ' таблица', 'теория игр', 'техника игры', 'технология', ' урок игр', ' фильмы', ' футбол', ' характеристика', ' хоккей', ' цель', 'цска', 'зенит', 'реал', 'мадрид', ' чемпионат', 'футбол', 'бизнес игры', 'любовные игры', 'спортивные', 'спорт', 'класс', 'уно', 'баста', 'гуф', 'игры мотыльков', 'игра в прятки']


    for r in s:
        #if r.IsA('TTouchYandexWebRequest'):
        #    ui = 'Touch'
        #elif r.IsA('TPadYandexWebRequest'):
        #    ui = 'Tablet'
        if r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        if r.ServiceDomRegion != 'ru':
            continue

        #ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]

        q = normalize_query(r.Query)

        if len(q) == 0:
            continue

        isH = 0
        isM = 0
        isS = 0

        for bl in r.GetMainBlocks():
            m = bl.GetMainResult()
            if m.IsA('TWebResult'):
                url = str(m.Url)
                for h in hosts:
                    if 'www.' + h in url or 'http://' + h in url or 'https://' + h in url:
                        isH = 1
                        host = h
                        break
                if isH == 1:
                    break

        for m in markers:
            if m in q:
                isM = 1
                break

        for stop in stop_words:
            if stop in q:
                isS = 1
                break

        if isH == 1:
            yield Record(uid,'',host, tableIndex = 0) # встретили хост

        if isM == 1 and isS == 0:
            yield Record(q,'',uid, tableIndex = 1) # встретили маркер и не встретили стоп-слово

def aggr(key,recs):
    i = 0
    for rec in recs:
        i += 1

    yield Record(key,'',str(i))


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )


    dates = ['20160310']
    for d in dates:
        #src = 'sample_by_yuid_1p/user_sessions/' + d
        src = 'user_sessions/' + d

        dt0 = 'ensuetina/GAMES/hosts'
        dt1 = 'ensuetina/GAMES/queries'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            appendMode = True,
                            sortMode = True
                            )

    MapReduce.runReduce(aggr,
                        srcTable = dt1,
                        dstTable = dt1 + '_aggr',
                        sortMode = True
                       )


if __name__ == '__main__':
    main()
