#-*-coding: utf8 -*-
from nile import (
    clusters,
    Record,
    aggregators as na,
    filters as nf,
    extractors as ne
)

import nile
from datetime import datetime
import uatraits, cgi
import libra

def Reduce(groups):

    detector = uatraits.detector('/usr/share/uatraits/browser.xml')

    for key,records in groups:
        uid = key.key

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TTouchYandexWebRequest'):
                ui = 'touch'
            else:
                continue

            ua = str(r.UserAgent)
            reqid = r.ReqID
            d = detector.detect(ua)

            BR = str(d.get('BrowserName'))
            OS = str(d.get('OSName'))
            OSF = str(d.get('OSFamily'))

            img = 0
            vid = 0

            for bl in r.GetBSBlocks():
                p = bl.Path
                if 'snippet/images/title' in p:
                    img += 1
                if 'snippet/video/more' in p:
                    vid += 1

            if img > 1 or vid > 1:
                yield Record(uid=uid,ui=ui,reqid=reqid,BR=BR,OS=OS,OSF=OSF,img=img,vid=vid)


def Reduce_portal(groups):

    for key,records in groups:
        uid = key.key

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TYandexPortalRequest'):
                ui = 'desktop portal'
            elif r.IsA('TTouchYandexPortalRequest'):
                ui = 'touch portal'
            elif r.IsA('TPadYandexPortalRequest'):
                ui = 'tablet portal'
            else:
                continue

#            ua = str(r.UserAgent)
#            d = detector.detect(ua)


#            BR = str(d.get('BrowserName'))
#            OS = str(d.get('OSName'))
#            OSF = str(d.get('OSFamily'))

            login = str(r.YandexLoginHash)
            isLogin = str(len(login)>0)
            cookie = str(r.YandexPermanentCookie)

            yield Record(uid=uid,ui=ui,login=login,isLogin=isLogin,cookie=cookie)


def find_cookies(recs):
    for rec in recs:
        uid = rec.key
        line = rec.value
        data = dict([d.split('=', 1) for d in line.split('\t') if '=' in d])

        t = str(data.get('type'))
        service = str(data.get('service'))
        reg = str(data.get('dom-region'))
        cookies = data.get('cookies')

        if t != 'ACCESS' or service != 'portal.yandex' or reg != 'ru' or not cookies:
            return

        #yield Record(uid,'',line, tableIndex = 0) # всего хитов РУ на морду

        cc = dict([d.split('=', 1) for d in line.split(' ') if '=' in d])

        L = cc.get('L')

        if not L:
            isL = 0
        else:
            isL = 1

        yield Record(uid=uid,L=L,isL=isL,cookies=cookies)




cluster = clusters.YT(proxy="hahn.yt.yandex.net").env(
                                                        job_root=('home/search-research/ensuetina/DOUBLE_SERP')
                                                    )

dates = ['03-11','03-18','03-25','04-01','04-08','04-15']
for date in dates:
    job = cluster.job()

    if date == '04-01':
        us = job.table('user_sessions/pub/search/daily/2016-' + date + '.broken/clean')
    else:
        us = job.table('user_sessions/pub/search/daily/2016-' + date + '/clean')

    t = us.groupby('key').sort('subkey').reduce(Reduce,files=[nile.files.LocalFile('/home/ensuetina/blockstat.dict'),nile.files.LocalFile('/home/ensuetina/libra.so')], memory_limit=2000).put('$job_root/data_' + date)

    t.groupby('img','vid').aggregate(count=na.count()).put('$job_root/aggr_' + date)

    job.run()

