#-*-coding: utf8 -*-
from nile import (
    clusters,
    Record,
    aggregators as na,
    filters as nf,
    extractors as ne
)

import nile
from datetime import datetime
import uatraits, cgi
import libra

def Reduce(groups):

    detector = uatraits.detector('/usr/share/uatraits/browser.xml')

    for key,records in groups:
        uid = key.key

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TYandexWebRequest'):
                ui = 'desktop'
            elif r.IsA('TTouchYandexWebRequest'):
                ui = 'touch'
            elif r.IsA('TPadYandexWebRequest'):
                ui = 'tablet'
            else:
                continue

            ua = str(r.UserAgent)
            d = detector.detect(ua)


            BR = str(d.get('BrowserName'))
            OS = str(d.get('OSName'))
            OSF = str(d.get('OSFamily'))

            login = str(r.YandexLoginHash)
            isLogin = str(len(login)>0)
            cookie = str(r.YandexPermanentCookie)

            yield Record(uid=uid,ui=ui,BR=BR,OS=OS,OSF=OSF,login=login,isLogin=isLogin,cookie=cookie)


def Reduce_portal(groups):

    for key,records in groups:
        uid = key.key

        try:
            session = libra.ParseSession(records, 'blockstat.dict')
        except:
            continue

        for r in session:
            if r.IsA('TYandexPortalRequest'):
                ui = 'desktop portal'
            elif r.IsA('TTouchYandexPortalRequest'):
                ui = 'touch portal'
            elif r.IsA('TPadYandexPortalRequest'):
                ui = 'tablet portal'
            else:
                continue

#            ua = str(r.UserAgent)
#            d = detector.detect(ua)


#            BR = str(d.get('BrowserName'))
#            OS = str(d.get('OSName'))
#            OSF = str(d.get('OSFamily'))

            login = str(r.YandexLoginHash)
            isLogin = str(len(login)>0)
            cookie = str(r.YandexPermanentCookie)

            yield Record(uid=uid,ui=ui,login=login,isLogin=isLogin,cookie=cookie)


def find_cookies(recs):
    for rec in recs:
        uid = rec.key
        line = rec.value
        data = dict([d.split('=', 1) for d in line.split('\t') if '=' in d])

        t = str(data.get('type'))
        service = str(data.get('service'))
        reg = str(data.get('dom-region'))
        cookies = data.get('cookies')

        if t != 'ACCESS' or service != 'portal.yandex' or reg != 'ru' or not cookies:
            return

        #yield Record(uid,'',line, tableIndex = 0) # всего хитов РУ на морду

        cc = dict([d.split('=', 1) for d in line.split(' ') if '=' in d])

        L = cc.get('L')

        if not L:
            isL = 0
        else:
            isL = 1

        yield Record(uid=uid,L=L,isL=isL,cookies=cookies)




cluster = clusters.YT(proxy="hahn.yt.yandex.net").env(
                                                        job_root=('home/search-research/ensuetina/GET_LOGINS')
                                                    )


job = cluster.job()

#us = job.table('user_sessions/pub/search/daily/2016-03-01/clean')

#t = us.groupby('key').sort('subkey').reduce(Reduce_portal,files=[nile.files.LocalFile('/home/ensuetina/blockstat.dict'),nile.files.LocalFile('/home/ensuetina/libra.so')]).put('$job_root/portal')

#t.put('$job_root/data')#, append=True)

#t = job.table('$job_root/data').project(ne.all(),isLogin=ne.custom(lambda x: str(len(x)>0), 'login')).put('$job_root/isLogin')

t = job.table('$job_root/portal')
#t.groupby('ui','isLogin','BR','OS','OSF').aggregate(requests=na.count()).put('$job_root/aggr')

t.groupby('ui','isLogin','cookie').aggregate(count=na.count()).put('$job_root/aggr_portal')

job.run()

