# -*- coding: UTF-8 -*-

from mapreducelib import MapReduce, Record
from collections import defaultdict
from datetime import datetime, timedelta, date
import libra
import urllib, re,random

def Reduce(key, recs):
    uid = key

    try:
        s = libra.ParseSession(recs, './blockstat.dict')
    except:
        return


    c = '23394'
    e1 = '23395'
    e2 = '23796'

    for r in s:
        if r.IsA('TYandexWebRequest'):
            ui = 'Desktop'
        else:
            continue

        ts =  str(datetime.fromtimestamp(r.Timestamp).isoformat()).split('T')[0]
        ua = str(r.UserAgent)
        q = str(r.Query)

        if r.HasTestID(c):
            slot = 'control ' + c
        elif r.HasTestID(e1):
            slot = 'exp ' + e1
        elif r.HasTestID(e2):
            slot = 'exp ' + e2
        else:
            continue

        isBNO = 0
        isVideo = 0
        isOA = 0
        isImages = 0

        for bl in r.GetBSBlocks():
            p = bl.Path
            if 'snippet/bno' in p:
                isBNO = 1
            if 'snippet/video/' in p:
                isVideo = 1
            if 'snippet/images/' in p:
                isImages = 1
            if 'parallel/object-answer' in p:
                isOA = 1


        for cl in r.GetClicks():
            if cl.IsA('TClick'):
                notMisc = 1
            else:
                notMisc = 0

            if cl.IsA('TMiscResultClick'):
                misc = 1
            else:
                misc = 0

            p = cl.ConvertedPath
            vv = str(cl.GetVars())
            dw = cl.DwellTime
            secs = cl.DelayAfterRequest
            dw2 = cl.DwellTimeOnService
            yield Record(uid,'',ui + '\t' + slot + '\t' + ts + '\t' + q + '\t' + p + '\t' + vv + '\t' + str(dw) + '\t' + str(secs) + '\t' + str(dw2) + '\t' + str(isBNO) + '\t' + str(isVideo) + '\t' + str(isOA) + '\t' + str(isImages) + '\t' + str(notMisc) + '\t' + str(misc), tableIndex = 1)


        yield Record(uid,'',slot + '\t' + ts + '\t' + str(r.PageNo), tableIndex = 0)


def main():

    MapReduce.useDefaults(
                            server   = 'sakura.search.yandex.net:8013',
                            username = 'userstats',
                            mrExec   = '/Berkanavt/bin/mapreduce-dev',
                            verbose  = True,
                            #testMode = True,
                         )

    dd = ['20160419']
    for d in dd:
        src = 'user_sessions/' + d

        dt0 = 'ensuetina/LEGO_EXP/queries'
        dt1 = 'ensuetina/LEGO_EXP/clicks'

        MapReduce.runReduce(Reduce,
                            srcTable = src,
                            dstTables = [dt0,dt1],
                            files = ['/home/ensuetina/data/blockstat.dict'],
                            #appendMode = True,
                            sortMode = True
                            )

if __name__ == '__main__':
    main()
