# -*- coding: UTF-8 -*-

from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)
import datetime
from qb2.api.v1 import (
    extractors as se,
    filters as sf
)

import nile


date_format = '%Y-%m-%d'

full_path_to_libra = '/home/ensuetina/libra.so'
full_path_to_blockstat = '/home/ensuetina/blockstat.dict'

username = 'ensuetina'

# выбираем кластер
cluster = clusters.yt.Hahn(pool = 'search-research_ensuetina',
                       ).env(templates=dict(
                                job_root='home/search-research/' + username + '/DISTRIBUTION_METRIC/PROMOLIB'
                            )
                            )

def map_name(AppID):
    name_dict = {'ru.yandex.mobile..realty': '.realty', 'ru.yandex.direct.inhouse': 'direct.inhouse',
            'ru.yandex.disk': 'Disk', 'ru.yandex.disk.inhouse': 'disk.inhouse', 'ru.yandex.yandexbus.inhouse.debug': 'inhouse.debug',
            'ru.yandex.direct.inhouse.globus': 'inhouse.globus', 'ru.yandex.mobile.metro.inhouse.new': 'inhouse.new',
            'com.yandex.mobile.job': 'Job', 'ru.yandex.mobile.rabota': 'Job', 'com.yandex.mobile.job.dev': 'job.dev',
            'ru.kinopoisk': 'Kinopoisk', 'ru.kinopoisk.dev': 'kinopoisk.dev', 'ru.yandex.mail': 'Mail',
            'ru.yandex.mail.debug': 'mail.debug', 'ru.yandex.traffic': 'Maps', 'ru.yandex.yandexmaps': 'Maps',
            'ru.yandex.ymarket': 'Market', 'ru.yandex.metro': 'Metro', 'ru.yandex.mobile.metro': 'Metro',
            'ru.yandex.mobile.metro.inhouse': 'metro.inhouse', 'P01yandex.mobile.navigator': 'mobile.navigator',
            'ru.yandex.mobile.music': 'Music', 'ru.yandex.mobile.music.inhouse': 'music.inhouse',
            'ru.yandex.mobile.navigator': 'Navigator', 'ru.yandex.yandexnavi': 'Navigator',
            'ru.yandex.mobile.navigator.inhouse': 'navigator.inhouse', 'ru.yandex.mobile.navigator.sandbox': 'navigator.sandbox',
            'ru.yandex.parking.sandbox': 'parking.sandbox', 'ru.yandex.promolib.sample': 'promolib.sample',
            'ru.yandex.promolib.samplesl': 'promolib.samplesl', 'ru.yandex.mobile.rabota.inhouse': 'rabota.inhouse',
            'com.yandex.mobile.realty': 'Realty', 'ru.yandex.mobile.realty': 'Realty',
            'com.yandex.mobile.realty.dev': 'Realty Dev', 'ru.yandex.mobile.realty.inhouse': 'realty.inhouse',
            'ru.yandex.promolib.sample.sl': 'sample.sl', 'ru.yandex.test.promolib': 'test.promolib',
            'ru.yandex.test.promolib_': 'test.promolib_', 'ru.yandex.test.promolib1': 'test.promolib1',
            'ru.yandex.traffic.inhouse': 'traffic.inhouse', 'ru.yandex.traffic.sandbox': 'traffic.sandbox',
            'ru.yandex.rasp': 'Trains', 'ru.yandex.mobile.transport': 'Transport', 'ru.yandex.yandexbus': 'Transport',
            'ru.yandex.mobile.transport.inhouse': 'transport.inhouse', 'com.voltmobi.ymarket': 'voltmobi.ymarket',
            'ru.yandex.mobile.weather-v2': 'Weather', 'ru.yandex.weatherplugin': 'Weather',
            'ru.yandex.mobile.weather-v2.inhouse': 'weather-v2.inhouse', 'ru.yandex.weatherplugin': 'Weather (?)',
            'ru.yandex.disl': 'yandex.disl', 'ru.yandex.meow': 'yandex.meow',
            'com.yandex.NativeTemplatesTableViewExample': 'yandex.NativeTemplatesTableViewExample',
            'com.globus.yandex.weather': 'yandex.weather', 'ru.yandex.yandexbus.inhouse': 'yandexbus.inhouse',
            'ru.yandex.yandexmaps.clone': 'yandexmaps.clone', 'ru.yandex.yandexmaps.debug': 'yandexmaps.debug',
            'ru.yandex.yandexmaps.inhouse': 'yandexmaps.inhouse', 'ru.yandex.yandexmaps.klone': 'yandexmaps.klone',
            'ru.yandex.yandexnavi.inhouse': 'yandexnavi.inhouse', 'ru.yandex.yandexnavi.sandbox': 'yandexnavi.sandbox',
            'ru.yandex.direct': 'Директ', 'ru.yandex.mobile.transport': 'Транспорт', 'ru.yandex.yandexbus': 'Транспорт'
           }

    name = name_dict.get(AppID)
    if not name:
        name = AppID
    return name

def devide(x,y):
    try:
        result = round(float(x)/float(y),2)
    except Exception as e:
        result = ''
    return result

def isAtom(event_value):
    if '-ATOMS-' in str(event_value):
        return 'atom'
    else:
        return 'not_atom'


date = datetime.datetime.today() + datetime.timedelta(days=-1)
date = date.strftime(date_format)
date_range = ['2016-06-25']#[date]

for day in date_range:
    #continue

    job = cluster.job()

    log = job.table('statbox/metrika-mobile-log/' + day)

    hits = log.qb2(log = 'metrika-mobile-log',
                    fields = ['app_platform','device_id','event_name','raw_event_value','session_type','date','log_line','event_type',
                              se.dictitem('AppID',from_='parsed_log_line'),
                              se.custom('app_name',map_name,'AppID')
                             ],
#                    filters = [
#                                sf.not_(sf.equals('session_type','SESSION_BACKGROUND'))
#                              ]
                   ).groupby('app_name',
                             'event_type'
                            ).aggregate(freq=na.count()).project(ne.all(),neg=ne.custom(lambda x: -1*x, 'freq')).sort('neg').put('$job_root/check_events')

    check = job.table('$job_root/check_events').groupby('event_type').aggregate(freq=na.sum('freq'),
                                          apps=na.count_distinct('app_name')
                                        ).project(ne.all(),neg=ne.custom(lambda x: -1*x,'apps')).sort('neg').put('$job_root/events_only')

    job.run()

    continue

    banners = log.qb2(log = 'metrika-mobile-log',
                    fields = ['app_platform','device_id','event_name','raw_event_value','session_type','date','log_line',
                              se.dictitem('AppID',from_='parsed_log_line'),
                              se.custom('app_name',map_name,'AppID'),
                              se.custom('isAtom',isAtom,'raw_event_value')
                             ],
                    filters = [
                                sf.contains('raw_event_value','campaign_id'),
                                sf.equals('event_name','display')
                              ]
                   ).groupby('app_name',
                             'app_platform',
                             'device_id',
                             'date',
                             'isAtom'
                            ).aggregate(banners=na.count()).groupby('date',
                                                                    'app_platform',
                                                                    'app_name',
                                                                    'isAtom'
                                                                   ).aggregate(users_who_saw_banners = na.count(),
                                                                               banners = na.sum('banners')
                                                                              ).put('$job_root/banners_show')
    dau = log.qb2(log = 'metrika-mobile-log',
                    fields = ['app_platform','device_id','event_name','raw_event_value','session_type','date','log_line',
                              se.dictitem('AppID',from_='parsed_log_line'),
                              se.custom('app_name',map_name,'AppID')
                             ],
                    filters = [
                                sf.not_(sf.equals('session_type','SESSION_BACKGROUND'))
                              ]
                   ).groupby('app_name',
                             'app_platform',
                             'device_id',
                             'date'
                            ).aggregate(tmp=na.count()).groupby('date',
                                                                'app_platform',
                                                                'app_name'
                                                               ).aggregate(dau = na.count()).put('$job_root/DAU')

    job.run()

#job = cluster.job()
#
#banners = job.table('$job_root/banners_show', ignore_missing=True)
#dau = job.table('$job_root/DAU',ignore_missing=True)
#
#t0 = banners.join(dau,by=('app_platform','app_name','date'),type='left')
#
#t1 = t0.groupby('app_platform','app_name','date').aggregate(banners = na.sum('banners'),
#                                                         users_who_saw_banners = na.sum('users_who_saw_banners'),
#                                                         dau = na.any('dau')
#                                                        ).project(ne.all(),isAtom=ne.const('_total_'))
#
#report_data = job.concat(t0,t1).project('app_platform',
#                                        'banners',
#                                        'dau',
#                                        'users_who_saw_banners',
#                                        fielddate = 'date',
#                                        app_id = 'app_name',
#                                        is_atom = 'isAtom',
#                                        banners_per_dau = ne.custom(devide,'banners','dau'),
#                                        users_who_saw_per_dau = ne.custom(devide,'users_who_saw_banners','dau'),
#                                        banners_per_user_who_saw_it = ne.custom(devide,'banners','users_who_saw_banners')
#                                       ).put('$job_root/report')
#
#job.run()
