#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import argparse
from nile.api.v1 import (
    clusters,
    filters as nf,
    extractors as ne,
    aggregators as na,
    Record
)
import datetime
import json


def process_serpset(serpset, basket_name, date, cl):
    result = []
    for serp in serpset:
        if serp['type'] != 'SERP':
            continue
        query = serp['query']['text']
        if 'components' not in serp:
            continue
        for comp in serp['components']:
            if comp['text.SERVER_DESCR'] != 'VIDEOQUICK':
                continue
            url = comp['componentUrl']['pageUrl']
            frames = comp.get('textLists.FRAMES_THUMBS') or []
            result.append(
                {
                    'query': query,
                    # 'basket': basket_name,
                    'date': date,
                    'url': url,
                    'frames': len(frames)
                }
            )
    cl.write(
        path='//home/videolog/frames_thumbs/{}/{}'.format(basket_name, date),
        records=[Record(**x) for x in result],
    )


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_v')
    parser.add_argument('--input_vt')
    parser.add_argument('--token')
    parser.add_argument('--date')
    args = parser.parse_args()

    cl = clusters.yt.Hahn(token=args.token)

    process_serpset(json.load(open(args.input_v)), 'validate', args.date, cl)
    process_serpset(
        json.load(open(args.input_vt)), 'validate_touch', args.date, cl
    )


if __name__ == "__main__":
    main()
