#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import os
import argparse
import json
import gzip
import StringIO
import datetime
import time
import requests
import yt.wrapper as yt


requests.packages.urllib3.disable_warnings()


baskets_yt_path = '//home/videolog/freon_baskets'


headers = {
    'Authorization': 'OAuth {}'.format(os.environ['METRICS_TOKEN'])
}


config = {
    'video': {
        'FreonVideoPolirovkaFresh': {
            '1d': '9274',
            '1d-xp': ('101194', '9274'),
            '3d': '9418',
            '3d-xp': ('101194', '9418')
        },
        'FreonVideoYandexFresh': {
            '1d': '9278',
            '1d-xp': ('101195', '9278'),
            '3d': '9422',
            '3d-xp': ('101195', '9422')
        },
        'FreonVideoYandexMain': {
            '1d': '9276',
            '1d-xp': ('101193', '9276'),
            '3d': '9420',
            '3d-xp': ('101193', '9420')
        },
        'FreonVideoGoogleFresh': {
            '1d': '9282',
            '1d-xp': ('101196', '9282'),
            '3d': '9426',
            '3d-xp': ('101196', '9426')
        },
        'FreonVideoGoogleMain': {
            '1d': '9280',
            '1d-xp': ('101197', '9280'),
            '3d': '9424',
            '3d-xp': ('101197', '9424')
        },
    }
}

########### images config part
#
#    'images': {
#        'FreonImagesPolirovkaFresh': {
#            '1d': '9284',
#            '1d-xp': ('101205', '9284'),
#            '3d': '9428',
#            '3d-xp': ('101205', '9428')
#        },
#        'FreonImagesYandexFresh': {
#            '1d': '9288',
#            '1d-xp': ('101204', '9288'),
#            '3d': '9432',
#            '3d-xp': ('101204', '9432')
#        },
#        'FreonImagesYandexMain': {
#            '1d': '9286',
#            '1d-xp': ('101203', '9286'),
#            '3d': '9430',
#            '3d-xp': ('101203', '9430')
#        },
#        'FreonImagesGoogleMain': {
#            '1d': '9290',
#            '1d-xp': ('101201', '9290'),
#            '3d': '9434',
#            '3d-xp': ('101201', '9434')
#        },
#        'FreonImagesGoogleFresh': {
#            '1d': '9292',
#            '1d-xp': ('101202', '9292'),
#            '3d': '9436',
#            '3d-xp': ('101202', '9436')
#        },
#    }


device_dict = {
    0: "DESKTOP",
    1: "ANDROID",
    2: "IPHONE",
    3: "UNKNOWN",
    4: "WINDOWS_PHONE"
}


enrichment_lists = {
    'images': [
        'COMPONENT.judgements.image_fresh_relevance',
        'COMPONENT.judgements.image_freshness',
        'COMPONENT.url.mimcaMdsUrl',
        'COMPONENT.judgements.images_vq3_v2',
        'SERP.metric.fresh_images_pFound_5',
        'SERP.metric.fresh_images_WpFound_5',
        'SERP.metric.fresh_images_queryfresh',
        'SERP.metric.fresh_images_serpfresh',
        'SERP.metric.fresh_images_withfresh',
        'SERP.metric.fresh_images_pFound_10',
        'SERP.metric.fresh_images_WpFound_10',
        'SERP.metric.fresh_images_queryfresh_10',
        'SERP.metric.fresh_images_serpfresh_10',
        'SERP.metric.fresh_images_withfresh_10',
        'SERP.metric.fresh_images_nonfresh-pFound_10',
    ],
    'video': [
        'COMPONENT.judgements.video_relevance',
        'COMPONENT.judgements.video_freshness',
        'SERP.metric.fresh_video_pFound_5',
        'SERP.metric.fresh_video_WpFound_5',
        'SERP.metric.fresh_video_queryfresh',
        'SERP.metric.fresh_video_serpfresh',
        'SERP.metric.fresh_video_withfresh',
    ]
}


enrichment_lists_only_metrics = {
    'images': [
        'SERP.metric.fresh_images_pFound_5',
        'SERP.metric.fresh_images_WpFound_5',
        'SERP.metric.fresh_images_queryfresh',
        'SERP.metric.fresh_images_serpfresh',
        'SERP.metric.fresh_images_withfresh',
        'SERP.metric.fresh_images_pFound_10',
        'SERP.metric.fresh_images_WpFound_10',
        'SERP.metric.fresh_images_queryfresh_10',
        'SERP.metric.fresh_images_serpfresh_10',
        'SERP.metric.fresh_images_withfresh_10',
        'SERP.metric.fresh_images_nonfresh-pFound_10',
    ],
    'video': [
        'SERP.metric.fresh_video_pFound_5',
        'SERP.metric.fresh_video_WpFound_5',
        'SERP.metric.fresh_video_queryfresh',
        'SERP.metric.fresh_video_serpfresh',
        'SERP.metric.fresh_video_withfresh',
    ]
}


metrics_for_check_enrichments = {
    'images': 'judged-10-image-fresh-relevance',
    'video': 'judged-10-video-freshness'
}


metrics_for_check = {
    'images': 'fresh_images_pFound_5',
    'video': 'fresh_video_pFound_5'
}


def check_serpset(id_, search_type, check_type='enrichment'):
    if check_type == 'enrichment':
        metrics_dict = metrics_for_check_enrichments
    elif check_type == 'metric':
        metrics_dict = metrics_for_check
    retries = 0
    j = None
    while not j and retries < 3:
        try:
            j = requests.get(
                'https://metrics-calculation.qloud.yandex-team.ru'
                '/api/qex/metric-observation?regional=RU&evaluation={st}'
                '&left-serp-set={s}&right-serp-set={s}'
                '&metric={metric}'.format(
                    s=id_, metric=metrics_dict[search_type],
                    st=search_type.upper()
                ),
                verify=False
            ).json()
        except Exception as e:
            retries += 1
            print('oops: {}'.format(e))
            time.sleep(5)
    return j[0]['leftData']['value'] >= 0.995


def get_serps(id_):
    retries = 0
    j = None
    while not j and retries <= 3:
        try:
            j = requests.get(
                'https://metrics-calculation.qloud.yandex-team.ru/api/json/'
                '{}?regional=RU&evaluation=VIDEO&aspect=availability_mobile'
                '&absolute=false&serpset-filter=onlySearchResult'.format(id_),
                verify=False, headers=headers
            )
        except Exception as e:
            print('oops: {}'.format(e))
            retries += 1
            time.sleep(5)
    return json.load(gzip.GzipFile(fileobj=StringIO.StringIO(j.content)))


def get_date(id_):
    retries = 0
    j = None
    while not j and retries < 3:
        try:
            j = requests.get(
                'http://metrics.yandex-team.ru/services/api/serpset/info'
                '?id={s}'.format(s=id_),
                verify=False
            ).json()
        except Exception as e:
            retries += 1
            print('oops: {}'.format(e))
            time.sleep(5)
    return datetime.datetime.strptime(
        j['date'].split('T')[0], '%Y-%m-%d'
    ).date()


QUOTA_DICT = {
    'video': 'VIDEO Freshness',
    'images': 'IMAGES Freshness',
}


def order_enrichment(serpset, search_type, enrichment_type='enrichment'):
    if enrichment_type == 'metric':
        enrichment_lists_dict = enrichment_lists_only_metrics
    elif enrichment_type == 'enrichment':
        enrichment_lists_dict = enrichment_lists
    spec = {
        "enrichments": [
            {
                "requirements": enrichment_lists_dict[search_type],
                "keys": [
                    {
                        "serpSetId": serpset,
                    }
                ],
                "depth": 10,
                "reevaluation": False,
                "regionalType": 'RU',
                "evaluationType": search_type.upper(),
                "additional": {
                    "angQuota": QUOTA_DICT[search_type],
                }
            }
        ],
        "priority": 50,
        "comment": "",
        "owner": "pecheny",
        "notificationMode": "FAILURES_ONLY"
    }
    req = requests.post(
        'https://metrics-calculation.qloud.yandex-team.ru/api/evaluate/create',
        headers=headers,
        json=spec,
        verify=False
    )
    return req


def serps_to_basket(serps):
    out = [x['query'] for x in serps]
    for x in out:
        x['device'] = device_dict[x['device']]
    return out


def get_serpsets(id_, date, search_type, days=3):
    if isinstance(id_, tuple):
        search_by = "cronSerpDownloadId={}&hostId={}".format(id_[0], id_[1])
    else:
        search_by = "cronSerpDownloadId={}".format(id_)
    return requests.get(
        'https://metrics.yandex-team.ru/services/api/serpset/list/RU/{}/'
        '?from={}T00:00:00.000&to={}T00:00:00.000'
        '&{}'.format(
            search_type.upper(),
            date - datetime.timedelta(days=days),
            date,
            search_by
        ), verify=False
    ).json()


def upload_basket_to_metrics(basket_name, queries):
    spec = {
        'type': 'RAW',
        'queries': queries
    }
    req = requests.post(
        'https://metrics-qgaas.metrics.yandex-team.ru/api/basket',
        headers=headers,
        params={'name': basket_name},
        json=spec,
        verify=False
    )
    return req


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--non_invasive', '-n', action='store_true')
    parser.add_argument('--type_only', '-to')
    parser.add_argument('--crons_only', '-co')
    parser.add_argument('--days', default=3, type=int)
    parser.add_argument('--result', default='freon_daily_result.json')
    args = parser.parse_args()
    date = datetime.date.today()
    result = []
    if args.crons_only:
        args.crons_only = args.crons_only.split(',')
    yt.config['proxy']['url'] = 'hahn.yt.yandex.net'
    yt.config['token'] = os.environ['YT_TOKEN']
    baskets = yt.list(baskets_yt_path)
    for search_type in sorted(config):
        for name in sorted(config[search_type]):
            cst = config[search_type][name]
            for type_ in sorted(cst):
                id_ = cst[type_]
                if args.crons_only and id_ not in args.crons_only:
                    continue
                print('[{}] {} {}'.format(search_type, name, type_))
                serpsets = get_serpsets(id_, date, search_type, days=args.days)
                print('loaded serpsets: {}'.format(serpsets))
                for serpset_id in serpsets:
                    print('checking serpset {} for type {} {}'.format(
                        serpset_id, name, type_
                    ))
                    serpset_date = get_date(serpset_id)
                    check = check_serpset(
                        serpset_id, search_type, check_type='enrichment'
                    )
                    if not check:
                        print('ordering enrichment')
                        if not args.non_invasive:
                            req = order_enrichment(
                                serpset_id, search_type
                            )
                            result.append(req.json())
                    else:
                        check1 = check_serpset(
                            serpset_id, search_type, check_type='metric'
                        )
                        if not check1:
                            print('ordering mstand')
                            if not args.non_invasive:
                                req = order_enrichment(
                                    serpset_id, search_type,
                                    enrichment_type='metric'
                                )
                                result.append(req.json())
                    basket_name = '{}_{}_{}'.format(
                        name, type_, serpset_date
                    )
                    if basket_name not in baskets:
                        print('uploading {} basket'.format(basket_name))
                        serps = get_serps(serpset_id)
                        queries = serps_to_basket(serps)
                        if not args.non_invasive:
                            yt.write_table(
                                '{}/{}'.format(baskets_yt_path, basket_name),
                                queries
                            )
                            req = upload_basket_to_metrics(
                                basket_name, queries
                            )
                            result.append(req.json())
    json.dump(
        result, open(args.result, 'w'), indent=2, sort_keys=True
    )


if __name__ == "__main__":
    main()
