#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import json
import argparse


def extract_date(s):
    return json.loads(s)['date']


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--output')
    parser.add_argument('input', nargs='+')
    args = parser.parse_args()

    toloka = json.load(open(args.input[0]))
    inp = json.load(open(args.input[1]))

    result = {}
    for el in toloka:
        result[
            (el['inputValues']['query'], el['inputValues']['url'])
        ] = el['outputValues']['relevance']

    for el in inp:
        date = extract_date(el.pop('SERP.text.additional'))
        el['dynamic_judgement:video_freshness'] = result[
            (date, el['component_page_url'])
        ]

    json.dump(inp, open(args.output, 'w'), indent=2, sort_keys=True)


if __name__ == "__main__":
    main()
