#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import json
import argparse


def extract_date(s):
    return json.loads(s)['date']


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--output')
    parser.add_argument('input', nargs='+')
    args = parser.parse_args()

    toloka = json.load(open(args.input[0]))
    inp = json.load(open(args.input[1]))

    result = {}
    for el in toloka:
        result[
            (
                el['inputValues']['query'],
                el['inputValues']['page_url'],
                el['inputValues']['image_url'],
                el['inputValues']['query_markup_update_date']
            )
        ] = (
            el['outputValues']['relevance'],
            el['outputValues'].get('quality', 'NOT_JUDGED'),
        )

    for el in inp:
        date = extract_date(el.pop('SERP.text.additional'))
        tup = (
            el['query_text'],
            el['component_page_url'],
            el['NULLABLE.COMPONENT.imageadd']['url'],
            date
        )
        el['dynamic_judgement:image_fresh_relevance'] = result[tup][0]
        el['dynamic_judgement:image_freshness'] = result[tup][1]

    json.dump(inp, open(args.output, 'w'), indent=2, sort_keys=True)


if __name__ == "__main__":
    main()
