#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import json
import copy


stub = {
    'inputValues': {
        'url': '',
        'code': ''
    },
    'knownSolutions': {
        'outputValues': {'result': ''}
    }
}


def main():
    obj = json.load(open('video_info_good_processed2.json'))
    result = []
    for x in obj:
        if 'iframe' in x:
            new = copy.deepcopy(stub)
            new['inputValues']['url'] = x['iframe_src']
            new['inputValues']['code'] = x['iframe']
            new['knownSolutions']['outputValues']['result'] = 'OK'
            result.append(new)
        if 'iframe_bad' in x:
            new = copy.deepcopy(stub)
            new['inputValues']['url'] = x['iframe_bad_src']
            new['inputValues']['code'] = x['iframe_bad']
            new['knownSolutions']['outputValues']['result'] = 'BAD'
            result.append(new)
    print('total honeypots: {}'.format(len(result)))
    json.dump(
        result, open('vdp_honeypots.json', 'w'), indent=2, sort_keys=True
    )



if __name__ == "__main__":
    main()
