#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import json
import copy


template = {
    "serp-request-id": 0,
    "per-query-parameters": {
        "region-id": 225,
        "additional-cgi": {"pron": ["grouping_aliasing_dgdocid:dg"]},
        "query-text": ""
    }
}


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('filename')
    parser.add_argument('--output', '-o', default='output.json')
    parser.add_argument('--nodg', action='store_true')
    args = parser.parse_args()

    with codecs.open(args.filename, 'r', 'utf8') as f:
        content = f.read()
    queries = [x.strip() for x in content.split('\n') if x]

    result = []

    for i, q in enumerate(queries):
        new = copy.deepcopy(template)
        if not args.nodg:
            new['per-query-parameters']['additional-cgi'] = {}
        new['serp-request-id'] = i
        new['per-query-parameters']['query-text'] = q
        result.append(new)

    json.dump(
        result,
        codecs.open(args.output, 'w', 'utf8'),
        indent=2,
        ensure_ascii=False
    )


if __name__ == "__main__":
    main()
