#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import argparse
import json
from nile.api.v1 import clusters
from videolog_common import StatPusher


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--table")
    parser.add_argument("--cluster")
    parser.add_argument("--scale", default="daily")
    parser.add_argument("--replace_mask")
    parser.add_argument("--report")
    args = parser.parse_args()

    with open(args.table) as f:
        table = json.load(f)

    cluster = getattr(clusters, table["cluster"].title())()

    kwargs = {"scale": args.scale}
    if args.replace_mask:
        kwargs["replace_mask"] = args.replace_mask

    sp = StatPusher(cluster=cluster, report=args.report, password_var="STAT_TOKEN", username_var=None)
    sp.push(table["table"], **kwargs)


if __name__ == "__main__":
    main()
