#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('input')
    parser.add_argument('output1')
    parser.add_argument('output2')
    parser.add_argument('--season', '-s', default=None)
    parser.add_argument('--episode', '-e', default=None)
    parser.add_argument('--bypass', '-b', action='store_true')
    args = parser.parse_args()

    with codecs.open(args.input, 'r', 'utf8') as i, \
            codecs.open(args.output1, 'w', 'utf8') as o1, \
            codecs.open(args.output2, 'w', 'utf8') as o2:
        for line in i:
            tabs = line.strip().split('\t')
            if len(tabs) < 3:
                continue
            if not args.bypass and (
                (args.season and tabs[2] != args.season) or
                (args.episode and tabs[3] != args.episode)
            ):
                continue
            o1.write('{}\t213\n'.format(tabs[0]))
            o2.write(line)


if __name__ == "__main__":
    main()
