#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import argparse
from nile.api.v1 import clusters
import time


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--token', default='')
    parser.add_argument(
        '--table', default='//home/videoquality/vuserdata2/'
        'external_data/external_factors/'
        'toloka_serial_queryurl_ok'
    )
    args = parser.parse_args()

    cl = clusters.Banach(token=args.token)

    job = cl.job()

    tables = [
        job.table(
            '//home/videoquality/vuserdata2/'
            'external_data/external_factors/'
            'toloka_serial_queryurl_ok_{}'.format(i),
            ignore_missing=True
        ) for i in range(1, 11)
    ]

    job.concat(*tables).put(args.table)

    ok = False
    retries = 0
    waittime = 4
    while not ok and retries <= 4:
        try:
            job.run()
            ok = True
        except Exception as e:
            print(format(e))
            print('retry #{}, waiting {} secs...'.format(
                retries + 1, 60 * waittime
            ))
            time.sleep(60 * waittime)
            waittime *= 2
            retries += 1
    if ok:
        print('everything is ok')
    else:
        print('failure limit reached :(')


if __name__ == "__main__":
    main()
