#!/usr/bin/env python
# -*- coding: utf-8 -*-

import nirvana.job_context as nv
import json
import itertools
import sys

def main():
    input_filename = nv.context().get_inputs().get('infiles')
    output_filename = nv.context().get_outputs().get('out_json')
    data = {}
    systems = set()
    with open(input_filename, "r") as input:
        for line in input:
            if not line.strip():
                continue
            tmp = line.strip().split("\t")
            video = tmp[0]
            url = tmp[1].replace("http://", "https://")
            s = tmp[2]
            systems.add(s)
            if not video in data:
                data[video] = {}
            data[video][s] = url

    pairs_list = list(itertools.permutations(list(systems), 2))
    toloka_prep = []
    for d in data:
        for pair in pairs_list:
            left_url = data[d][pair[0]]
            right_url = data[d][pair[1]]
            toloka_prep.append({"inputValues" :
                                {
                                   "question" : u'Какое видео менее дефектное?',
                                   "url_left": "<iframe src=https://yastatic.net/yandex-video-player-iframe-api/?hq_url=%s&preload=false&loop=true frameborder=0 scrolling=yes allowfullscreen=1 width=1280 height=720></iframe>" % left_url,
                                   "url_right": "<iframe src=https://yastatic.net/yandex-video-player-iframe-api/?hq_url=%s&preload=false&loop=true frameborder=0 scrolling=yes allowfullscreen=1 width=1280 height=720></iframe>" % right_url,
                                    "sys_id_left" : pair[0],
                                    "sys_id_right" : pair[1],
                                    "screen_name": d
                                 }
                               })

    print >> sys.stderr, "Total systems", systems
    print >> sys.stderr, "Total pairs %s" % len(pairs_list)
    print >> sys.stderr, "Total comparisons %s" % len(toloka_prep)
    with open(output_filename, 'w') as output:
        json.dump(toloka_prep, output, indent = 4)
    output.close()

if __name__ == '__main__':
    main()
