#!/usr/bin/env python
# -*- coding: utf-8 -*-

import nirvana.job_context as nv
import datetime
import json

def main():
    input_filename = nv.context().get_inputs().get('infiles')
    output_filename = nv.context().get_outputs().get('out_json')

    param = nv.context().get_parameters().get('input-params').split(";")
    date = param[0]
    scale = param[1]
    device = param[2]
    logname = param[3]

    adjust_dict = {
        ("spylog", "desktop") : "32, 10",
        ("spylog", "touch") : "43, 10",
        ("similargroup", "desktop") : "37, 10",
        ("similargroup", "touch") : "44, 10",
        ("watchlog", "desktop") : "21, 10",
        ("similargroup", "touch") : "21, 10",
    }

    log_dict = {
        ("spylog", "desktop") : "//user_sessions/pub/spy_log/daily",
        ("spylog", "touch") : "//user_sessions/pub/metrika_mobile_log/daily",
        ("similargroup", "desktop") : "//user_sessions/pub/similargroup/daily",
        ("similargroup", "touch") : "//user_sessions/pub/similargroup_mobile/daily",
        ("watchlog", "desktop") : "//logs/bs-watch-log/1d",
        ("watchlog", "touch") : "//logs/bs-watch-log/1d",
    }

    enddate = datetime.datetime.strptime(date, "%Y-%m-%d")
    if scale == "weekly":
        startdate = enddate - datetime.timedelta(days = 6)
        date = startdate.strftime("%Y-%m-%d")
    elif scale == "monthly":
        startdate = enddate.replace(day = 1)
        date = startdate.strftime("%Y-%m-%d")

    with open(input_filename, "r") as input:
        query = input.read()
    query = query.replace("${global.date}", date)
    query = query.replace("${global.enddate}", enddate.strftime("%Y-%m-%d"))
    query = query.replace("${global.scale}", scale)
    query = query.replace("${global.logname}", logname)
    query = query.replace("${global.adjust}", adjust_dict[(logname, device)])
    if scale != "daily" and "pirate" not in query and "concat" not in query:
        if logname != "watchlog":
            query = query.replace("{{input1}}", "range(`%s`,`%s`,`%s`, `clean`)" % (log_dict[(logname, device)], startdate.strftime("%Y-%m-%d"), enddate.strftime("%Y-%m-%d")))
        else:
            query = query.replace("{{input1}}", "range(`%s`,`%s`,`%s`)" % (log_dict[(logname, device)], startdate.strftime("%Y-%m-%d"), enddate.strftime("%Y-%m-%d")))
    if "PoolTrees" not in query:
        query = 'PRAGMA yt.PoolTrees = "physical";\nPRAGMA yt.UseDefaultTentativePoolTrees;\n' + query

    with open(output_filename, 'w') as output:
        json.dump({"request" : query}, output, indent = 4)
    output.close()

if __name__ == '__main__':
    main()
