#-*- coding: UTF-8 -*-
import nile
import argparse
import time
from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record,
    cli,
    with_hints,
)
from qb2.api.v1 import (
    extractors as qe,
    filters as qf
)
from copy import deepcopy
import datetime
import os
import sys
import json
from qb2.api.v1.typing import *

@with_hints(output_schema=dict(fielddate=String, ui=String, query=String, place=String, domain=String, youtube_8=Integer, youtube_16=Integer))
def process(recs):
    for rec in recs:
        youtube_10 = 0
        youtube_20 = 0

        cats = ["_total_"]
        if rec["SearchPropsValues"].get("VIDEO.VideoPorno.vidprn") == "ipq1":
            cats.append("porn")
        else:
            cats.append("not_porn")
        if float(rec["RelevValues"].get("vserial", "0")) > 0:
            cats.append("serial")
        if str(rec["RelevValues"].get('mut')) == '5' or str(rec["RelevValues"].get('muvt')) == '2' or str(rec["RelevValues"].get('mu')) == '1' or str(rec["RelevValues"].get('muvt')) == '1' or str(rec["RelevValues"].get('muvt')) == '2':
            cats.append("music")
        if "Film/Film/" in str(rec.get("obj_type", "")):
            cats.append("film")

        for res in rec.get("results", []):
            if res["pos"] < 10 and res["player"] == "youtube":
                youtube_10 += 1
            if res["pos"] < 20 and res["player"] == "youtube":
                youtube_20 += 1

        domain = rec.get("domain") if rec.get("domain") else "_other_"
        for ui in [rec.get("ui"), "_total_"]:
            for dom in [domain, "_total_"]:
                for place in [rec.get("related"), "_total_"]:
                    for cat in cats:
                        yield Record(fielddate = rec.get("fielddate"), ui=ui,
                                     query = cat, place=place, domain = dom,
                                     youtube_8 = 1 if youtube_10 > 7 else 0,
                                     youtube_16 = 1 if youtube_20 > 15 else 0
                                     )


@cli.statinfra_job
def make_job(job, options, statface_client):

    job = job.env(
        yt_spec_defaults=dict(
            pool_trees=["physical"],
            use_default_tentative_pool_trees=True
            ),
        templates=dict(
            tmp_root='//tmp',
            title='Youtube_much'
            )
        )

    report = ns.StatfaceReport() \
        .path('Video.All/youtube_serp') \
        .scale('daily') \
        .client(statface_client)

    date = options.dates[0]

    cube = job.table('home/videoquality/24julia/video_queries_cube/' + date) \
              .project(
                ne.all(),
                related=ne.const("main")
                ) \
              .map(process)
    cube_related = job.table('home/videoquality/24julia/video_queries_cube.related/' + date) \
              .project(
                ne.all(),
                related=ne.const("related")
                ) \
              .map(process)
    procecced = job.concat(cube, cube_related) \
                    .groupby("fielddate", "ui", "query", "place", "domain") \
                    .aggregate(requests = na.count(),
                               yt_8 = na.sum("youtube_8"),
                               yt_16 = na.sum("youtube_16")) \
                    .publish(report)

    return job


if __name__ == '__main__':
    cli.run()
