#!/usr/bin/env python
# -*- coding: utf-8 -*-

import yt.wrapper as yt
import sys
import argparse
import datetime
import pytz
import json

def HandleOption():
    parser = argparse.ArgumentParser()
    parser.add_argument("--server", dest = "server", help = "mapreduce server", default = 'arnold.yt.yandex.net:80', required = False)
    parser.add_argument("--date", dest = "date", help = "date", required = True)
    parser.add_argument("--out", dest = "out", help = "output with metrics", required = True)
    return parser


def main():
    args = HandleOption().parse_args()
    yt.update_config({'proxy': {'url': args.server}})

    index = []
    moscow = pytz.timezone("Europe/Moscow")
    for row in yt.read_table("//home/videoindex/full/index/deployed/production"):
        date_tz = moscow.localize(datetime.datetime.fromtimestamp(row["ts"]))
        date = datetime.datetime(date_tz.year, date_tz.month, date_tz.day)
        index.append(date)

    index = sorted(index)

    out = []
    enddate = datetime.datetime.strptime(args.date, "%Y-%m-%d")
    startdate = enddate - datetime.timedelta(days = 6)

    i = 0
    while i < len(index) and index[i] < startdate:
        i += 1

    release_count = 0
    last_release = index[-1]
    release_date = False
    while i < len(index) and index[i] <= enddate:
        release_count += 1
        last_release = index[i]
        if index[i] == enddate:
            release_date = True
        i += 1

    stat = {
        "fielddate": enddate.strftime("%Y-%m-%d"),
        "index_weekly" : release_count,
        "index_age" : (enddate - last_release).days,
        }
    if release_date:
        stat["release_date"] = 1
        print >> sys.stderr, enddate.strftime("%Y-%m-%d")
    out.append(stat)

    with open(args.out, "w") as outfile:
        json.dump(out, outfile, indent = 4)

if __name__ == '__main__':
    main()
