#!/usr/bin/env python
# -*- coding: utf-8 -*-

import nirvana.job_context as nv
import datetime
import json

def main():
    input_filename = nv.context().get_inputs().get('infiles')
    output_filename = nv.context().get_outputs().get('out_json')

    param = nv.context().get_parameters().get('input-params').split(";")
    date = param[0]


    enddate = datetime.datetime.strptime(date, "%Y-%m-%d")
    startdate = enddate.replace(day = 1)
    date = startdate.strftime("%Y-%m-%d")

    with open(input_filename, "r") as input:
        query = input.read()
    query = query.replace("${global.date}", date)
    query = query.replace("${global.enddate}", enddate.strftime("%Y-%m-%d"))


    with open(output_filename, 'w') as output:
        json.dump({"request" : query}, output, indent = 4)
    output.close()

if __name__ == '__main__':
    main()
