# -*- coding: UTF-8 -*-
import json
import random
import argparse

parser = argparse.ArgumentParser()
parser.add_argument('--input', type=argparse.FileType('r'))
parser.add_argument('--output', type=argparse.FileType('w'))

def compare(old, new, h):
    if old < h and new >= h:
        return 1
    elif old >= h and new < h:
        return -1
    return 0

def bootstrap_mean(x):
    s = 0.0
    for i in range(len(x)):
        s += random.choice(x)
    return s/len(x)

def make_html(row1, row2, row3):
    line1 = '<tr style="background:%s"><td>score</td><td>%.4f</td><td>%.4f</td><td>%.4f</td><td>%.4f</td><td>%s</td><td>%s</td></tr>\n' %row1
    line2 = '<tr style="background:%s"><td>docs with score>=0.4</td><td>%d</td><td>%d</td><td>%d</td><td>%.1f</td><td>%s</td><td>%s</td></tr>\n' %row2
    line3 = '<tr style="background:%s"><td>docs with score>=0.6</td><td>%d</td><td>%d</td><td>%d</td><td>%.1f</td><td>%s</td><td>%s</td></tr>\n' %row3

    html = '<html>\n<style>\n table {border: 1px solid grey;} th {border: 1px solid grey;} td {border: 1px solid grey;}\n</style>\n<table>\n<tr><th></th><th>old</th><th>new</th><th>diff</th><th>mean_bs</th><th>interval 99%</th><th>interval 95%</th></tr>\n' + line1 + line2 + line3 + '</table>\n</html>'

    return html

def find_color(mean, int1_left, int1_right, int5_left, int5_right):
    color_code = {'grey' : '#CCCCCC', 'green' : '#33FF33', 'light_green' : '#CCFFCC', 'red' : '#FF3333', 'light_red' : '#FFCCCC'}
    if int1_left > 0 and mean > 0:
        return color_code['green']
    if mean < 0 and int1_right < 0:
        return color_code['red']
    if int5_left > 0 and mean > 0:
        return color_code['light_green']
    if mean < 0 and int5_right < 0:
        return color_code['light_red']
    return color_code['grey']

def mean(x):
    return sum(x)*1.0/len(x)

if __name__ == '__main__':
    args = parser.parse_args()

    data = json.loads(args.input.read())

    diff = [x['new_thumbs']['img_wins_share'] - x['thumbs']['img_wins_share'] for x in data]
    diff04 = [compare(x['thumbs']['img_wins_share'], x['new_thumbs']['img_wins_share'], 0.4) for x in data]
    diff06 = [compare(x['thumbs']['img_wins_share'], x['new_thumbs']['img_wins_share'], 0.6) for x in data]


    b = [bootstrap_mean(diff) for i in range(10000)]
    b.sort()
    color = find_color(mean(b), b[50], b[9950], b[250], b[9750])
    row1 = (color,
             mean([x['thumbs']['img_wins_share'] for x in data]),
             mean([x['new_thumbs']['img_wins_share'] for x in data]),
             mean(diff),
             mean(b),
             '(%.4f, %.4f)' % (b[50], b[9950]),
             '(%.4f, %.4f)' % (b[250], b[9750])
            )

    b = [bootstrap_mean(diff04) for i in range(10000)]
    b.sort()
    color = find_color(mean(b), b[50], b[9950], b[250], b[9750])
    row2 = (color,
             len([x['thumbs']['img_wins_share'] for x in data if x['thumbs']['img_wins_share'] >= 0.4]),
             len([x['new_thumbs']['img_wins_share'] for x in data if x['new_thumbs']['img_wins_share'] >= 0.4]),
             mean(diff04)*len(diff04),
             mean(b)*len(diff04),
             '(%.1f, %.1f)' % (b[50]*len(diff04), b[9950]*len(diff04)),
             '(%.1f, %.1f)' % (b[250]*len(diff04), b[9750]*len(diff04))
            )

    b = [bootstrap_mean(diff06) for i in range(10000)]
    b.sort()
    color = find_color(mean(b), b[50], b[9950], b[250], b[9750])
    row3 = (color,
             len([x['thumbs']['img_wins_share'] for x in data if x['thumbs']['img_wins_share'] >= 0.6]),
             len([x['new_thumbs']['img_wins_share'] for x in data if x['new_thumbs']['img_wins_share'] >= 0.6]),
             mean(diff06)*len(diff06),
             mean(b)*len(diff06),
             '(%.1f, %.1f)' % (b[50]*len(diff06), b[9950]*len(diff06)),
             '(%.1f, %.1f)' % (b[250]*len(diff06), b[9750]*len(diff06))
            )

    out = make_html(row1, row2, row3)
    args.output.write(out)
