import json
import argparse


parser = argparse.ArgumentParser()
parser.add_argument('--input', type=argparse.FileType('r'))
parser.add_argument('--output', type=argparse.FileType('w'))

if __name__ == '__main__':
    args = parser.parse_args()

    data = json.loads(args.input.read())
    for elem in data:
        elem['diff'] = elem['thumbs']['img_wins_share'] - elem['new_thumbs']['img_wins_share']

    data.sort(key = lambda x: x['diff'], reverse = True)
    html_text = '<html>'
    html_text += '<pre>     thums                                              new thumbs</pre>'
    for elem in data:
        html_text += ('<img src= %s >\n' %elem['thumbs']['thumbnail'])
        html_text += ('<img src= %s >\n' %elem['new_thumbs']['thumbnail'])
        html_text += ('title=%s, UUID=%s, diff=%.3f<br>\n' %(elem['thumbs']['title'], elem['thumbs']['UUID'], elem['diff']))
    html_text += '</html>'

    args.output.write(html_text.encode('utf-8'))
