# -*- coding: UTF-8 -*-
import json
import argparse
import pandas as pd

parser = argparse.ArgumentParser()
parser.add_argument('--input', type=argparse.FileType('r'))
parser.add_argument('--output', type=argparse.FileType('w'))
parser.add_argument('--fieldname')

if __name__ == '__main__':
    args = parser.parse_args()

    res = pd.DataFrame.from_dict(json.loads(args.input.read()))

    out = ''
    out += 'Среднее:                  %.2f \n' %res[args.fieldname].mean()
    out += '0.75-квантиль:            %.2f \n' %res[args.fieldname].quantile(q=0.75)
    out += '0.5-квантиль (медиана):   %.2f \n' %res[args.fieldname].quantile(q=0.5)
    out += '0.25-квантиль:            %.2f \n' %res[args.fieldname].quantile(q=0.25)
    out += 'Доля с метрикой >= 1:     %.2f \n' %(len(res[res[args.fieldname] >= 1]) * 1.0 / len(res))
    out += 'Доля с метрикой >= 0.75:  %.2f \n' %(len(res[res[args.fieldname] >= 0.75]) * 1.0 / len(res))
    out += 'Доля с метрикой >= 0.5:   %.2f \n' %(len(res[res[args.fieldname] >= 0.5]) * 1.0 / len(res))
    out += 'Доля с метрикой >= 0.4:   %.2f \n' %(len(res[res[args.fieldname] >= 0.4]) * 1.0 / len(res))
    out += 'Доля с метрикой >= 0.6:   %.2f \n' %(len(res[res[args.fieldname] >= 0.6]) * 1.0 / len(res))

    args.output.write(out)
