def add_to_html(title, UUID, score, thumbnail, winners, losers):
    html_text = ''
    html_text += '<p  style="font-size: 32px">title=%s</p>' %title
    html_text += '<p  style="font-size: 24px">UUID=%s, score=%0.3f</p>' %(UUID, score)
    html_text += 'thumbnail: <img src = %s ><br>\n' %thumbnail
    html_text += 'winners: '
    for img in winners:
        html_text += '<img src = %s >' %img
    html_text += '<br>\nlosers: '
    for img in losers:
        html_text += '<img src = %s >' %img
    html_text += '<br>\n'
    return html_text


import json
import argparse

parser = argparse.ArgumentParser()
parser.add_argument('--input', type=argparse.FileType('r'))
parser.add_argument('--output', type=argparse.FileType('w'))

if __name__ == '__main__':
    args = parser.parse_args()

    dat = json.loads(args.input.read())

    html_text = '<html>\n'

    for UUID_group in dat:
        UUID = UUID_group[0]['UUID']
        title = UUID_group[0]['title']
        thumbnail = UUID_group[0]['avatars_url_0']
        winners = []
        losers = []
        better, equal, worse = 0, 0, 0
        for res in UUID_group:
            if res['wins1'] in [7,8]:
                winners.append(res['avatars_url_1'])
            if res['wins1'] in [0,1]:
                losers.append(res['avatars_url_1'])
            if res['wins0'] > res['wins1']:
                better += 1
            if res['wins0'] < res['wins1']:
                worse += 1
            if res['wins0'] == res['wins1']:
                equal += 1
        score = (1.0 * better + 0.5 * equal) / (better+equal+worse)
        html_text += add_to_html(title, UUID, score, thumbnail, winners, losers)

    html_text += '</html>'
    args.output.write(html_text.encode('utf-8'))

