import json
import argparse

parser = argparse.ArgumentParser()
parser.add_argument('--input', type=argparse.FileType('r'))
parser.add_argument('--output', type=argparse.FileType('w'))

if __name__ == '__main__':
    args = parser.parse_args()

    out_json = []

    for UUID_group in json.loads(args.input.read()):
        UUID = UUID_group[0]['UUID']
        title = UUID_group[0]['title']
        thumbnail = UUID_group[0]['avatars_url_0']
        wins, loses = 0, 0
        better, equal, worse = 0, 0, 0
        art_sum, art_count = 0.0,0.0
        for res in UUID_group:
            wins += res['wins0']
            loses += res['wins1']
            if res['wins0'] > res['wins1']:
                better += 1
            if res['wins0'] < res['wins1']:
                worse += 1
                art_sum += (res['wins1'] * 1.0 / (res['wins0'] + res['wins1']))
                art_count += 1
            if res['wins0'] == res['wins1']:
                equal += 1
                art_sum += 0.25
                art_count += 0.5
        out_json.append({'UUID' : UUID, \
                         'wins_share' : (wins * 1.0 / (wins + loses)), \
                         'img_wins_share' : ((1.0 * better + 0.5 * equal) / (better+equal+worse)), \
                         'art_score' : art_sum / art_count if art_count > 0 else 0, \
                         'thumbnail' : thumbnail, \
                         'title' : title})

    args.output.write(json.dumps(out_json))
