# -*- coding: UTF-8 -*-
import requests
import json
import argparse
import time
import os

parser = argparse.ArgumentParser()
parser.add_argument('--input', type=argparse.FileType('r'))
parser.add_argument('--output', type=argparse.FileType('w'))

if __name__ == '__main__':
    args = parser.parse_args()

    headers = {"Content-Type": "application/json", "Authorization": "OAuth %s" %os.environ["MY_TOKEN"]}

    taskid_list = [elem['sbs']['id'] for elem in json.loads(args.input.read())]
    for taskid in taskid_list:
        req = requests.get("https://sbs.yandex-team.ru/api/experiment/%d/results" %taskid, headers = headers, verify = False)
        while 'status' in req.json():
            if req.json()['status'] in [u'Отменён', u'Завершился с ошибкой']:
                raise Exception("task %d failed" %taskid)
            time.sleep(60)
            req = requests.get("https://sbs.yandex-team.ru/api/experiment/%d/results" %taskid, headers = headers, verify = False)

    out = []
    for taskid in taskid_list:
        req = requests.get("https://sbs.yandex-team.ru/api/experiment/%d/results?queries=1" %taskid, headers = headers, verify = False)
        out.append({'taskid' : taskid, 'results' : req.json()})

    args.output.write(json.dumps(out))
