# -*- coding: UTF-8 -*-
import json
import argparse
import os
import time
import requests

parser = argparse.ArgumentParser()
parser.add_argument('--input', type=argparse.FileType('r'))
parser.add_argument('--output', type=argparse.FileType('w'))
parser.add_argument('--size', type=int)
parser.add_argument('--delay', type=int)


def SplitData (data, size):
    out_data = []
    parts = 0
    while size * parts < len(data):
        out_data.append(data[size * parts : size * (parts + 1)])
        parts += 1
    return out_data

def MakeUrlsUuidUnique (data):
    json_out = []
    url_counter = {}
    uuid_counter = {}
    for elem in data:
        if elem['avatars_url_0'] not in url_counter:
            avatars_url_0 = elem['avatars_url_0']
            url_counter[elem['avatars_url_0']] = 1
        else:
            avatars_url_0 = elem['avatars_url_0'] + '?some_dust=%d' %url_counter[elem['avatars_url_0']]
            url_counter[elem['avatars_url_0']] += 1
        if elem['avatars_url_1'] not in url_counter:
            avatars_url_1 = elem['avatars_url_1']
            url_counter[elem['avatars_url_1']] = 1
        else:
            avatars_url_1 = elem['avatars_url_1'] + '?some_dust=%d' %url_counter[elem['avatars_url_1']]
            url_counter[elem['avatars_url_1']] += 1
        if elem['UUID'] not in uuid_counter:
            UUID = elem['UUID']
            uuid_counter[elem['UUID']] = 1
        else:
            UUID = elem['UUID'] + '_%d' %uuid_counter[elem['UUID']]
            uuid_counter[elem['UUID']] += 1
        json_out.append({'UUID' : UUID, 'title' : elem['title'], \
                         'url_orig_0':elem['url_orig_0'], 'url_orig_1':elem['url_orig_1'], \
                         'avatars_url_0':avatars_url_0, 'avatars_url_1':avatars_url_1, })
    return json_out

def JsonForSbs (data, title):
    out_json = {"type": "layout",
                "experiment": {"title": title,
                               "description": u"Попарное сравнение тумбов",
                               "goodTasks": 5,
                               "badTasks": 0,
                               "poolTitle": "desktop_no_comments",
                               "layouts": {"systems": [{ "name": u"первая картинка" },{ "name": u"вторая картинка" }],
                                           "screens": [],
                                           "layouts": [],
                                           },
                               "configOverride": json.dumps({ "toloka":{"overlap": 4}, "main": {"auto-start":True} })
                               }
               }
    for elem in data:
        out_json['experiment']['layouts']['screens'].append({
                    'name' : elem['UUID'],
                    'question' : u'Какая из двух картинок красивее и лучше описывает ролик с названием  "' + elem['title'] + '"'})
        out_json['experiment']['layouts']['layouts'].append({
                    'screens' : [{"origUrl" : elem['avatars_url_0']}, {"origUrl" : elem['avatars_url_1']}] })
    return out_json

def SendToSbs (sbs_json):
    headers = {"Content-Type": "application/json", \
               "Authorization": "OAuth %s" %os.environ["MY_TOKEN"]}
    req = requests.post("https://sbs.yandex-team.ru/api/experiment/start", \
                        data = json.dumps(sbs_json), headers = headers, verify = False)
    return req.json()


if __name__ == '__main__':
    args = parser.parse_args()

    out = []
    part = 1
    for data_part in SplitData(json.loads(args.input.read()), args.size):
        answer = SendToSbs(JsonForSbs(MakeUrlsUuidUnique(data_part), 'Тумбы видео: часть %d' %part))
        part += 1
        out.append({'data' : data_part, 'sbs' : answer})
        time.sleep(args.delay)
    args.output.write(json.dumps(out))
