# -*- coding: UTF-8 -*-
import json
import argparse
import pandas as pd

parser = argparse.ArgumentParser()
parser.add_argument('--input', type=argparse.FileType('r'))
parser.add_argument('--output', type=argparse.FileType('w'))
parser.add_argument('--fieldname')

if __name__ == '__main__':
    args = parser.parse_args()

    res = pd.DataFrame.from_dict(json.loads(args.input.read()))

    html_text = '<html>'
    res.sort_values(by=args.fieldname, ascending=False, inplace=True)
    html_text += '<p  style="font-size: 32px">BEST</p><br>'
    for index, row in res[:30].iterrows():
        html_text += ('<img src='+row['thumbnail']+'>  ' +row['title']+'   '+ str(row[args.fieldname])+'<br>\n')
    res.sort_values(by=args.fieldname, ascending=True, inplace=True)
    html_text += '<p  style="font-size: 32px">WORST</p><br>'
    for index, row in res[:30].iterrows():
        html_text += ('<img src='+row['thumbnail']+'>  ' +row['title']+'    '+ str(row[args.fieldname])+'<br>\n')
    html_text += '</html>'

    args.output.write(html_text.encode('utf-8'))
