from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    cli,
    with_hints,
    clusters,
    Record
)
from qb2.api.v1 import (
    extractors as se,
    filters as sf
)
from qb2.api.v1 import typing as qt

import nile
import json
import math
import os


@cli.statinfra_job
def make_job(job, options, statface_client):
    report = ns.StatfaceReport() \
        .path('Video.All/Others/compareTVT2')\
        .scale('daily')\
        .client(statface_client)

    final = job.table('//home/videolog/liza-p/mma-2667/regular_calc/$date spy-log (stats)')
    final.publish(report, allow_change_job=True)

    return job


if __name__ == "__main__":
    cli.run()

