from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)

import nile
import math
import argparse
import os


def parse_us(groups):
    for key, recs in groups:
        import libra
        try:
            session = libra.ParseSession(recs, './blockstat.dict')
        except Exception as e:
            continue

        tvt, lvt = 0, 0
        for req in session:
            if (not req.IsA('TYandexVideoRequest')) and (not req.IsA('TYandexRelatedVideoRequest')):
                continue
            if req.ServiceDomRegion != 'ru':
                continue
            if req.GetBrowser()[0] != 'YandexBrowser':
                continue

            tvt, lvt = 0, 0
            for block in req.GetMainBlocks():
                result = block.GetMainResult()
                if not result.IsA("TVideoResult"):
                    continue
                view_time = 0
                dur = req.FindVideoDurationInfo(result)
                if dur:
                    view_time = min(dur.PlayingDuration, dur.Duration)
                hb = req.FindVideoHeartbeat(result, "ANY")
                if hb:
                    view_time = max(view_time, hb.Ticks)
                tvt += view_time
                if view_time > 30:
                    lvt += math.log(view_time - 25.)

            yield Record(uid=key.key, tvt=tvt, lvt=lvt)


parser = argparse.ArgumentParser()
parser.add_argument('--date')
args = parser.parse_args()
date = args.date

cluster = clusters.yt.Hahn()
job = cluster.job()

job.table('//user_sessions/pub/search/daily/%s/clean' %date).groupby('key').sort('subkey') \
          .reduce(parse_us,
                  files=[nile.files.RemoteFile('statbox/statbox-dict-last/blockstat.dict'),
                         nile.files.RemoteFile('statbox/resources/libra.so')],
                  memory_limit=4000
                 ).put('//home/videolog/liza-p/mma-2667/regular_calc/%s user_sessions(prepared records)' %date
                      ).groupby().aggregate(tvt=na.sum('tvt'), lvt=na.sum('lvt'), uids=na.count_distinct('uid')
                                           ).project(ne.all(), fielddate=ne.const(date), host=ne.const('yandex.ru/video(user_sessions)')
                                                    ).put('//home/videolog/liza-p/mma-2667/regular_calc/%s user_sessions (stats)' %date)

job.run()

client = ns.StatfaceProductionClient(token = os.environ['STAT_TOKEN'])

ns.StatfaceReport().path('Video.All/Others/compareTVT2') \
                   .scale('daily') \
                   .client(client) \
                   .remote_publish(proxy='hahn',
                                   table_path='//home/videolog/liza-p/mma-2667/regular_calc/%s user_sessions (stats)' %date)
