import argparse
import json

parser = argparse.ArgumentParser()
parser.add_argument('--faces', type = float)
parser.add_argument('--boundaries', type = float)
parser.add_argument('--ripples', type = float)
parser.add_argument('--text', type = float)
parser.add_argument('--spots', type = float)

parser.add_argument('--input', type=argparse.FileType('r'))
parser.add_argument('--output', type=argparse.FileType('w'))

if __name__ == '__main__':
    args = parser.parse_args()

    data = json.loads(args.input.read())
    for elem in data:
        elem['result']['dr'] = (args.faces * elem['result']['faces'] + \
                               args.boundaries * elem['result']['boundaries'] + \
                               args.ripples * elem['result']['ripples'] + \
                               args.text * elem['result']['text'] + \
                               args.spots * elem['result']['spots']) * 1.0 / \
                        (args.faces + args.boundaries + args.ripples + args.text + args.spots)
    args.output.write(json.dumps(data))

