#-*-coding: utf8 -*-
import json
import random
import argparse

parser = argparse.ArgumentParser()
parser.add_argument('--input1', type=argparse.FileType('r'))
parser.add_argument('--input2', type=argparse.FileType('r'))
parser.add_argument('--output', type=argparse.FileType('w'))

def alg_aspects (data):
    result = {}
    for elem in data:
        for alg in elem.keys():
            if alg == 'title':
                continue
            for aspect in elem[alg].keys():
                result.setdefault(alg, {}).setdefault(aspect, []).append(elem[alg][aspect])
    return result

def mean(x):
    return sum(x)*1.0/len(x)

def html_table_mean(data, algs, aspects):
    aa = alg_aspects(data)
    html = '<b>mean</b><br>'
    html += ('<style>\n table {border: 1px solid grey;} th {border: 1px solid grey;} td {border: 1px solid grey;}\n</style>\n<table>\n<tr><th></th>' + '<th>%s</th>'*len(aspects) + '</tr>\n') %tuple(aspects)
    for alg in algs:
        html += '<tr><td>%s</td>' %alg
        for aspect in aspects:
            html += '<td>%.4f</td>' %mean(aa[alg][aspect])
        html += '</tr>\n'
    html += '</table><br>'
    return html

def html_table_max(data, algs, aspects):
    aa = alg_aspects(data)
    html = '<b>max</b><br>'
    html += ('<style>\n table {border: 1px solid grey;} th {border: 1px solid grey;} td {border: 1px solid grey;}\n</style>\n<table>\n<tr><th></th>' + '<th>%s</th>'*len(aspects) + '</tr>\n') %tuple(aspects)
    for alg in algs:
        html += '<tr><td>%s</td>' %alg
        for aspect in aspects:
            html += '<td>%.4f</td>' %max(aa[alg][aspect])
        html += '</tr>\n'
    html += '</table><br>'
    return html

def find_color(mean, int1_left, int1_right, int5_left, int5_right):
    color_code = {'grey' : '#CCCCCC', 'green' : '#33FF33', 'light_green' : '#CCFFCC', 'red' : '#FF3333', 'light_red' : '#FFCCCC'}
    if int1_left > 0 and mean > 0:
        return color_code['green']
    if mean < 0 and int1_right < 0:
        return color_code['red']
    if int5_left > 0 and mean > 0:
        return color_code['light_green']
    if mean < 0 and int5_right < 0:
        return color_code['light_red']
    return color_code['grey']

def bootstrap_mean(x):
    s = 0.0
    for i in range(len(x)):
        s += random.choice(x)
    return s/len(x)

def html_table_bs (data, algs, aspect):
    html = '<b>%s</b><br>' %aspect
    html += ('<style>\n table {border: 1px solid grey;} th {border: 1px solid grey;} td {border: 1px solid grey;}\n</style>\n<table>\n<tr><th></th>' + '<th>%s</th>'*len(algs) + '</tr>\n') %tuple(algs)
    for alg1 in algs:
        html += '<tr><td>%s</td>' %alg1
        for alg2 in algs:
            diff = [x[alg1][aspect] - x[alg2][aspect] for x in data]
            b = [bootstrap_mean(diff) for i in range(10000)]
            b.sort()
            color = find_color(mean(b), b[50], b[9950], b[250], b[9750])
            html += '<td style="background:%s"> %.4f</td>' %(color, mean(diff))
        html += '</tr>\n'
    html += '</table><br>'
    return html

#----------------------------
def find_examples (data, alg, aspect):
    data_filtered = [(elem['inputValues']['video'].split()[1][4:], elem['result'][aspect]) for elem in data if elem['inputValues']['algorithm'] == alg]
    m = max([elem[1] for elem in data_filtered] + [0])
    data_filtered_max = [elem for elem in data_filtered if elem[1] == m]
    res = random.sample(data_filtered_max, min(10, len(data_filtered_max)))
    if len(res) >= 5:
        return res
    m2 = max([elem[1] for elem in data_filtered if elem[1] != m] + [0])
    data_filtered_max2 =  [elem for elem in data_filtered if elem[1] == m2]
    res2 = random.sample(data_filtered_max2, min(10-len(res), len(data_filtered_max2)))
    return res+res2

def html_examples (data, algs, aspects):
    html = '<b>examples</b><br>'
    html += ('<style>\n table {border: 1px solid grey;} th {border: 1px solid grey;} td {border: 1px solid grey;}\n</style>\n<table>\n<tr><th></th>' + '<th>%s</th>'*len(aspects) + '</tr>\n') %tuple(aspects)
    for alg in algs:
        html += '<tr><td>%s</td>' %alg
        for aspect in aspects:
            hrefs = ''
            for ex in find_examples(data, alg, aspect):
                hrefs += '<a href = %s> %.1f </a>' %ex
            html += '<td>%s</td>' %hrefs
        html += '</tr>\n'
    html += '</table><br>'
    return html

def html_comments (data, algs):
    html = '<b>comments</b><br>'
    for alg in algs:
        html += '<b>%s</b><br>' %alg
        data_filtered = [(elem['inputValues']['video'].split()[1][4:],
                          [x for x in elem['result'].get('comments', []) if x]) for elem in data \
                         if elem['inputValues']['algorithm'] == alg
                            and len([x for x in elem['result'].get('comments', []) if x]) > 0]
        data_filtered.sort(key = lambda (url, comments): len(comments), reverse = True)
        for elem in data_filtered[:10]:
            html += '<a href = %s>%s</a><br>' % (elem[0], ' | '.join(elem[1]))
    return html


if __name__ == '__main__':
    args = parser.parse_args()

    res = json.loads(args.input1.read())
    res2 = json.loads(args.input2.read())

    aa = alg_aspects(res)
    algs = aa.keys()
    algs.sort()

    algs2 = list(set([elem['inputValues']['algorithm'] for elem in res2]))
    algs2.sort()

    aspects = ['faces', 'boundaries', 'ripples', 'text', 'spots', 'dr']


    args.output.write(('<html>\n' +
                     html_table_mean(res, algs, aspects) + html_table_max(res, algs, aspects) +
                     html_table_bs(res, algs, 'dr') +
                     html_table_bs(res, algs, 'faces') +
                     html_table_bs(res, algs, 'boundaries') +
                     html_table_bs(res, algs, 'ripples') +
                     html_table_bs(res, algs, 'text') +
                     html_table_bs(res, algs, 'spots') +
                     html_examples(res2, algs2, aspects) +
                     html_comments(res2, algs2) +
                     '</html>').encode('utf-8'))
