#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import argparse
import yt.wrapper as yt


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--table')
    parser.add_argument('--output')
    args = parser.parse_args()

    timestamp = None
    viewers = None
    results = []
    f = open(args.output, "w")
    for rec in yt.read_table(args.table):
        if timestamp is None:
            timestamp = rec["timestamp"]
            viewers = rec["starts"] - rec["finishes"]
        else:
            for timestamp_ in range(timestamp, rec["timestamp"]):
                f.write("{}\t{}\n".format(timestamp_, viewers))
            viewers += rec["starts"] - rec["finishes"]
            timestamp = rec["timestamp"]

    f.close()




if __name__ == "__main__":
    main()
