#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import argparse
from nile.api.v1 import (
    clusters,
    filters as nf,
    extractors as ne,
    aggregators as na,
    Record
)
import getpass
import random


def choose_lr(lr):
    total = sum(w for c, w in lr.items())
    r = random.uniform(0, total)
    upto = 0
    for c, w in lr.items():
        if upto + w >= r:
            return c
        upto += w
    assert False, "Shouldn't get here"


def main():
    hahn = clusters.yt.Hahn(
        pool='search-research_{}'.format(getpass.getuser())
    ).env(
        templates=dict(
            job_root='//home/videolog/new_baskets_lrs_ts',
        )
    )

    job = hahn.job()

    job.table(
        '$job_root/table'
    ).project(
        ne.all(), lr_chosen=ne.custom(choose_lr, 'lr')
    ).sort(
        'country', 'platform', 'service'
    ).put(
        '$job_root/table_chosen'
    )

    job.run()


if __name__ == "__main__":
    main()
