#!/usr/bin/env python
# -*- coding: utf-8 -*-
# from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import json

from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    clusters,
    Record
)

from qb2.api.v1 import extractors as se, filters as sf

import nile
from nile.utils.misc import coerce_path
# import libra
import datetime
import uatraits
import urllib
import re
import random
import urlparse
import getpass

username = getpass.getuser()


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('jsonfile')
    args = parser.parse_args()

    cluster = clusters.yt.Hahn(
        pool='search-research_pecheny', token=os.environ['YT_TOKEN']
    ).env(
        templates=dict(
            job_root='home/videolog/sbr'
        ),
        parallel_operations_limit=10
    )

    obj = json.load(open(args.jsonfile))

    page_urls = [
        Record(page_url=x['inputValues']['url'])
        for x in obj if x['outputValues']['result'] != 'YES'
    ]

    cluster.write(
        records=page_urls,
        path='$job_root/urls_blacklist',
        append=True
    )

    job = cluster.job()

    job.table(
        '$job_root/urls_blacklist'
    ).unique('page_url').sort('page_url').put(
        '$job_root/urls_blacklist'
    )

    job.run()


if __name__ == "__main__":
    main()
