#!/usr/bin/env python
# -*- coding: utf-8 -*-
import argparse
import json


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input', nargs='+')
    parser.add_argument('--output', default='output.json')
    args = parser.parse_args()

    result = set()

    player_urls = {}
    for filename in args.input:
        obj = json.load(open(filename))
        result |= set(tuple(x) for x in obj['pairs'])
        player_urls.update(obj['player_urls'])

    result = [
        {
            "url1": pair[0],
            "url2": pair[1],
            "player_url1": player_urls.get(pair[0]) or "",
            "player_url2": player_urls.get(pair[1]) or "",
        } for pair in result
    ]

    json.dump(list(result), open(args.output, 'w'))


if __name__ == "__main__":
    main()
