#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import json
import codecs
import argparse


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('input')
    parser.add_argument('output')
    args = parser.parse_args()

    in_ = json.load(open(args.input))

    result = []
    for obj in in_:
        result.append({"url": obj["url1"], "code": obj["player_url1"]})

    json.dump(result, codecs.open(args.output, 'w', 'utf8'), indent=2)


if __name__ == "__main__":
    main()
