#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import argparse
from nile.api.v1 import (
    clusters,
    filters as nf
)
import json


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--date')
    parser.add_argument('--output')
    parser.add_argument('--pool')
    parser.add_argument(
        '--input_table',
        default='//home/videolog/selrank_stats/additive_both_fields'
    )
    args = parser.parse_args()

    kwargs = {'token': os.environ['YT_TOKEN']}
    if args.pool:
        kwargs['pool'] = args.pool

    date = args.date.strip()
    output_table = '//home/videolog/mma-1574/daily/{}'.format(date)

    cluster = clusters.yt.Hahn(**kwargs)

    job = cluster.job()

    job.table(
        args.input_table
    ).filter(
        nf.custom(
            lambda x: date in (x or {}), 'data'
        )
    ).project(
        'page_url', 'frame_url'
    ).put(
        output_table
    )

    job.run()

    json.dump(
        {'cluster': 'hahn', 'table': output_table},
        open(args.output, 'w')
    )


if __name__ == "__main__":
    main()
