$getVideoFreshIntent = ($sprops) -> {
    $sp1 = String::SplitToList($sprops, ",");
    $sp2 = ListMap($sp1, ($x)->(String::SplitToList($x, "=")));
    $freshintent = ListFilter($sp2, ($x)->($x[0] == "QueryFreshintent"));
    $freshintent = ListMap($freshintent, ($x)->(CAST($x[1] as Double)));
    return ListMax($freshintent) ?? null
};

$getImagesFreshIntent = ($sprops) -> {
    $sp1 = String::SplitToList($sprops, ",");
    $sp2 = ListMap($sp1, ($x)->(String::SplitToList($x, "=")));
    $fmls = ListFilter($sp2, ($x)->($x[0] == "ApplyImagesBlender.fmls"));
    $fmls_val = $fmls[0][1];
    $sp3 = ListMap(String::SplitToList($fmls_val, "|"), ($x) -> (String::SplitToList($x, ":")));
    $imq = ListFilter($sp3, ($x)->($x[0] == "IMAGESQUICK"));
    return if(
        ListLength($imq) > 0,
        CAST($imq[0][1] as Double),
        null
    )
};

$badSymbols = Re2::Replace("[^a-zа-яё 0-9]");
$multiSpaces = Re2::Replace(" +");
$normalizeQuery = ($query)->{
    $query = CAST($query as Utf8);
    $query = Unicode::Fold($query, "Russian" as Language, false as DoRenyxa);
    $query = CAST($query as String);
    $query = $badSymbols($query, " ");
    $query = $multiSpaces($query, " ");
    $query = String::Strip($query);
    RETURN $query
};

export $getImagesFreshIntent, $getVideoFreshIntent, $normalizeQuery;