use hahn;
pragma library("queries_spikes_common.sql");
import queries_spikes_common symbols $getVideoFreshIntent, $getImagesFreshIntent, $normalizeQuery;

$input_tables = @[input_tables];
$ts_threshold_for_tmp_low = @[ts_threshold_for_tmp_low];
$ts_threshold_for_tmp_high = @[ts_threshold_for_tmp_high];
$ts_threshold_for_spikes = @[ts_threshold_for_spikes];
$users_threshold_for_tmp = @[users_threshold_for_tmp];
$users_threshold_for_spikes = @[users_threshold_for_spikes];
$fresh_intent_extractor = @[fresh_intent_extractor];
$tmp_table = "@[tmp_table]";
$output_table = "@[output_table]";

define subquery $fresh_queries_candidates(
    $input_tables,
    $ts_threshold_low,
    $ts_threshold_high,
    $fresh_intent_extractor,
    $users_threshold
) as
$tmp = (
    select
        cast(subkey_unixtime as Uint64) / 3600 * 3600 as hour,
        $normalizeQuery(TSKV_DATA.query) as request,
        $fresh_intent_extractor(TSKV_DATA.search_props) as fresh_intent,
        key_uid as user
    from each($input_tables)
    where CAST(subkey_unixtime as Uint64) >= $ts_threshold_low
    and CAST(subkey_unixtime as Uint64) <= $ts_threshold_high
);

$grouped1 = (
    SELECT
        request, hour, count(*) as `count`, CountDistinctEstimate(user) as users, some(user) as some_user, MEDIAN(fresh_intent) as fresh_intent_median, PERCENTILE(fresh_intent, 0.9) as fresh_intent_p90
    from $tmp
    where request is not null and length(request) > 0
    group by request, hour
);

$grouped2 = (
    select
        request, listsort(aggregate_list(astuple(hour, `count`, users, some_user, fresh_intent_median, fresh_intent_p90))) as data
    from $grouped1
    group by request
);
select * from $grouped2
where ListSum(ListMap(data, ($x)->($x.2))) >= $users_threshold;
end define;

/*create_new_map
$map = select * from $fresh_queries_candidates(
    $input_tables,
    $ts_threshold_for_tmp_low,
    $ts_threshold_for_tmp_high,
    $fresh_intent_extractor,
    $users_threshold_for_tmp
);
create_new_map*/

/*save_tmp
insert into $tmp_table with truncate
select * from $map;
save_tmp*/

/*use_existing_map
$map = select * from $tmp_table;
use_existing_map*/

$input_type = Struct<
    data: List<Tuple<Uint64?, Uint64, Uint64, String?, Double?, Double?>>,
    request: String?,
>;

$output_type = Struct<
    request: String?,
    data: List<Tuple<Uint64?, Uint64, Uint64, String?, Double?, Double?>>,
    ts: UInt64,
    yandexuid: String?,
    fresh_intent_median: Double?,
    fresh_intent_p90: Double?
>?;

$spikesMaker = Python::Mapper(
    Callable<
        (UInt64, UInt64)->
        Callable<($input_type)->$output_type>
    >, FileContent("spikes_mapper.py")
)($ts_threshold_for_spikes, $users_threshold_for_spikes);

insert into $output_table with truncate
process $map using $spikesMaker(TableRow());
