class Mapper:
    def __init__(self, ts_threshold, users_threshold):
        self.ts_threshold = ts_threshold
        self.users_threshold = users_threshold

    def __call__(self, rec):
        acc = 0
        for tup in rec.data:
            ts, count, users, some_user, fresh_intent_median, fresh_intent_p90 = (
                tup
            )
            if (
                ts >= self.ts_threshold
                and users > self.users_threshold
                and users >= acc
            ):
                return {
                    "request": rec.request,
                    "ts": ts,
                    "data": rec.data,
                    "yandexuid": some_user,
                    "fresh_intent_median": fresh_intent_median,
                    "fresh_intent_p90": fresh_intent_p90,
                }
            acc += users
