#-*- coding: UTF-8 -*-
from common import *

FUTURE_GAP = 50 * 60 * 60
FUTURE_GAP_WITH_LIVES = 1 * 60 * 60

def filter_by_channels_uuids(chain, channels_uuids):
    if not chain:
        return False
    for elem in chain:
        if elem["UUID"] in channels_uuids:
            return True
    return False

def in_channel_uuids(uuid, uuids):
    return uuid in uuids

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--table', type=str, required=True)
    parser.add_argument('--date', type=str, required=True)
    parser.add_argument('--days_to_calc_stats', type=int, required=True)
    parser.add_argument('--channel_id', type=str, required=True)
    parser.add_argument('--repeatability', type=int, required=True)
    parser.add_argument('--min_content_views_count', type=int, required=True)
    parser.add_argument('--schedule_gap', type=int, required=True)
    parser.add_argument('--with_ads', type=int, required=True)
    parser.add_argument('--ads_period', type=int, required=True)
    parser.add_argument('--channels_uuids', nargs='+', required=True)
    parser.add_argument('--lives', type=str, required=True)
    parser.add_argument('--live_channels_uuids', nargs='+', default=[])
    args = parser.parse_args()

    cluster = clusters.yt.Hahn().env(parallel_operations_limit=10,
                                     yt_spec_defaults=dict(
                                         pool_trees=["physical"],
                                         tentative_pool_trees=["cloud"]
                                     ),
                                     templates=dict(
                                         tmp_root='//tmp',
                                         title='GetSportYandexChannelSchedule'
                                     ))

    print "Live channels uuids", args.live_channels_uuids
    lives_timestamps = []
    for rec in cluster.driver.read(args.lives):
        if rec["YaTvChannel.UUID"] in args.live_channels_uuids:
            lives_timestamps.append([int(rec["start_time_ts"]), int(rec["finish_time_ts"])])

    lives_timestamps = sorted(lives_timestamps)

    print "Live timestamps", lives_timestamps

    end_date = datetime.strptime(args.date, "%Y-%m-%d")

    calc_content_stats(cluster, end_date, args.days_to_calc_stats)

    ### Calc possible content ids stats
    possible_content_ids_stats_table = "//tmp/msvvitaly/possible_content_ids_stats_table_" + str(time())
    job = cluster.job()

    job.table(ACTUAL_URLS).map(filter_bitrate, files=nfi_common) \
                          .project('UUID', 'ComputedName', 'ParentUUID', 'Parent2UUID', duration=ne.custom(lambda x : x.get('duration', 0), 'Resources')) \
                          .join(job.table(CONTENT_STATS_PATH), by='UUID', type='left') \
                          .filter(sf.or_(sf.custom(lambda x : filter_by_channels_uuids(x, args.channels_uuids), 'chain'),
                                         sf.custom(lambda x, y : in_channel_uuids(x, args.channels_uuids) or in_channel_uuids(y, args.channels_uuids), 'ParentUUID', 'Parent2UUID'))) \
                          .sort('views') \
                          .put(possible_content_ids_stats_table)

    job.run()

    possible_content_ids_stats = {}
    total_duration = 0
    for rec in cluster.driver.read(possible_content_ids_stats_table):
        if rec.get("views"):
            views = int(rec["views"])
        else:
            views = 0
        duration = int(rec["duration"])
        if views > args.min_content_views_count and duration > MIN_CONTENT_DURATION:
            total_duration += duration
            possible_content_ids_stats[rec["UUID"]] = {'views' : views, 'duration' : duration}

    print "Possible videos count {}. Total content duration {}".format(len(possible_content_ids_stats), total_duration)

    current_ts = int(time())

    gap = FUTURE_GAP
    if len(args.live_channels_uuids) > 0:
        gap = FUTURE_GAP_WITH_LIVES

    old_schedule_part = "//tmp/msvvitaly/old_schedule_part_" + str(current_ts)
    last_schedule_ts = get_old_schedule_part(cluster, args.table, old_schedule_part, FUTURE_GAP, current_ts)
    new_schedule_end_ts = current_ts + args.schedule_gap

    IS_BEGIN = 0
    IS_END = 1
    times = []
    for channel_uuid in args.channels_uuids:
        programs = get_channel_programs(channel_uuid, current_ts + FUTURE_GAP, new_schedule_end_ts)
        for program in programs:
            times.append([program['start_time'], IS_BEGIN])
            times.append([program['end_time'], IS_END])
    times = sorted(times, key=lambda x : [x[0], x[1] != IS_BEGIN])

    merged_times = []
    current_start_time = 0
    current_program_count = 0
    for i in range(len(times)):
        if current_program_count == 0 and times[i][1] == IS_BEGIN:
            current_start_time = times[i][0]
        if current_program_count == 1 and times[i][1] == IS_END:
            merged_times.append([current_start_time, times[i][0]])
        if times[i][1] == IS_BEGIN:
            current_program_count += 1
        else:
            current_program_count -= 1

    new_schedule_part, new_schedule_end_ts = make_schedule(possible_content_ids_stats,
                                                           last_schedule_ts,
                                                           new_schedule_end_ts,
                                                           args.repeatability,
                                                           args.with_ads,
                                                           args.ads_period,
                                                           lives_timestamps)
    new_schedule_part_table = "//tmp/msvvitaly/new_schedule_part" + str(current_ts)
    cluster.driver.write(new_schedule_part_table, new_schedule_part)

    job = cluster.job()

    new_schedule_part_joined = job.table(ACTUAL_URLS).map(map_au, files=nfi_common) \
                                  .join(job.table(new_schedule_part_table), by_left='contentUuid', by_right='UUID') \
                                  .project(ne.all(exclude=('pageId', 'yatvChannelPageId', 'begin', 'end')),
                                           pageId=ne.custom(lambda x, y : x if y else '', 'pageId', 'with_ads'),
                                           yatvChannelPageId=ne.custom(lambda x, y : x if y else '', 'yatvChannelPageId', 'with_ads'),
                                           withoutTimeline=ne.const('0'),
                                           begin=ne.custom(lambda x : int(x), 'begin'),
                                           end=ne.custom(lambda x : int(x), 'end')) \
                                  .map(make_event_id(args.channel_id), files=nfi_common)

    job.concat(job.table(old_schedule_part), new_schedule_part_joined) \
       .sort('begin') \
       .put(new_schedule_part_table + "_merged")

    job.run()

    if cluster.driver.exists(args.table):
        cluster.driver.remove(args.table)
    cluster.driver.copy(new_schedule_part_table + "_merged", args.table)

    cluster.driver.client.set_attribute(args.table, '_max_ts', new_schedule_end_ts)

if __name__ == '__main__':
    main()
