#-*- coding: UTF-8 -*-
import nile
import argparse
import time
from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)
from qb2.api.v1 import (
    extractors as se,
    filters as sf
)
import yt.wrapper as yt
import datetime
import os

DSP_LOG_PREFIX = "//logs/bs-dsp-log/1d"

class dsp_log_mapper(object):
    def __init__(self, minutely=False):
        self.minutely = minutely
    def __call__(self, recs):
        from datetime import datetime
        for rec in recs:
            block_shows = (rec.countertype == "1" and rec.win == "1")
            wins = (rec.countertype == "0" and rec.win == "1" and rec.dspid not in ["5", "10"])
            hits = (rec.countertype == "0" and rec.win == "1")
            if self.minutely:
                fielddate =  datetime.fromtimestamp(int(rec.eventtime) // 300 * 300).strftime('%Y-%m-%d %H:%M:00')
            else:
                fielddate = datetime.fromtimestamp(int(rec.eventtime)).strftime('%Y-%m-%d')
            yield Record(fielddate=fielddate,
                         pageid=rec.pageid,
                         block_shows=block_shows,
                         wins=wins,
                         hits=hits)

def push_to_stat_new(report_table, scale, report, stat_username, stat_token):
    client = ns.StatfaceClient(proxy='upload.stat.yandex-team.ru',
                               username=stat_username,
                               token=stat_token)

    ns.StatfaceReport().path(report) \
                       .scale(scale) \
                       .client(client) \
                       .remote_publish(proxy='hahn',
                                       table_path=report_table,
                                       async_mode=False,
                                       upload_config=False)

def calc_dsp_data(date, stat_username, stat_token):
    cluster = clusters.yt.Hahn().env(parallel_operations_limit=10,
                                  yt_spec_defaults=dict(
                                    pool_trees=["physical"],
                                    tentative_pool_trees=["cloud"]
                                  ),
                                  templates=dict(
                                    tmp_root='//home/videolog/tmp',
                                    title='DPSStatsByPageId'
                                  ))
    while not cluster.driver.exists(DSP_LOG_PREFIX + "/" + date):
        print "No tables"
        time.sleep(100)
    job = cluster.job()
    filtered_log = job.table(DSP_LOG_PREFIX + "/" + date) \
                      .filter(sf.and_(sf.equals('dspfraudbits', "0"),
                              sf.and_(sf.equals('dspeventflags', "0"),
                              nf.or_(nf.equals('pageid', '277519'),
                                     nf.equals('pageid', '277526'),
                                     nf.equals('pageid', '278948'),
                                     nf.equals('pageid', '277524'),
                                     nf.equals('pageid', '280195'),
                                     nf.equals('pageid', '277527')))))
    filtered_log.map(dsp_log_mapper()) \
                .groupby("fielddate", "pageid") \
                .aggregate(block_shows=na.sum("block_shows"),
                           wins=na.sum("wins"),
                           hits=na.sum("hits")) \
                .project(ne.all(),
                         se.custom('viewability', lambda x, y : 100. * x / max(y, 1), 'block_shows', 'wins')) \
                .put("//tmp/mma_1784/daily_" + date)
    filtered_log.map(dsp_log_mapper(minutely=True)) \
                .groupby("fielddate", "pageid") \
                .aggregate(block_shows=na.sum("block_shows"),
                           wins=na.sum("wins"),
                           hits=na.sum("hits")) \
                .project(ne.all(),
                         se.custom('viewability', lambda x, y : 100. * x / max(y, 1), 'block_shows', 'wins')) \
                .put("//tmp/mma_1784/minutely_" + date)
    job.run()
    push_to_stat_new("//tmp/mma_1784/daily_" + date, 'daily', "Video.All/CMF_DSP_STAT", stat_username, stat_token)
    push_to_stat_new("//tmp/mma_1784/minutely_" + date, 'minutely', "Video.All/CMF_DSP_STAT", stat_username, stat_token)

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--date', type=str, required=True)
    parser.add_argument('--stat_username', type=str, required=True)
    parser.add_argument('--stat_token', type=str, required=True)
    args = parser.parse_args()
    calc_dsp_data(args.date, args.stat_username, args.stat_token)

if __name__ == '__main__':
    main()
