#-*- coding: UTF-8 -*-
import nile
import argparse
import time
from nile.api.v1 import (
    filters as nf,
    aggregators as na,
    extractors as ne,
    statface as ns,
    clusters,
    Record
)
from qb2.api.v1 import (
    extractors as se,
    filters as sf
)
import yt.wrapper as yt
from datetime import datetime
from datetime import timedelta
import json
import os

class VHLogParser(object):
    def __init__(self, time_delta=60 * 5):
        self.time_delta = time_delta
    def __call__(self, recs):
        from datetime import datetime
        api_list = ["stop", "player", "ping", "channels", "episodes",
                    "program_episodes", "genre_episodes", "carousels",
                    "vod_libraries", "vod_episodes", "statistics",
                    "black_windows", "golovan/statistics", "strm_regions",
                    "channels_regions"]
        for rec in recs:
            fielddate = datetime.fromtimestamp(int(rec["timestamp"]) // self.time_delta * self.time_delta).strftime('%Y-%m-%d %H:%M:00')
            ts = int(rec["timestamp"])
            api_cutted = rec["request"].split("?")[0]
            for api_candidate in api_list:
                if api_candidate in api_cutted:
                    yield Record(fielddate=fielddate, api=api_candidate, count=1, ts=ts)
                yield Record(fielddate=fielddate, api='all', count=1, ts=ts)

def push_to_stat_new(report_table, report=None):
    client = ns.StatfaceClient(proxy='upload.stat.yandex-team.ru',
                               username='robot_msvvitaly',
                               token=os.environ['STAT_TOKEN'])

    ns.StatfaceReport().path(report) \
                       .scale('minutely') \
                       .replace_mask('fielddate') \
                       .client(client) \
                       .remote_publish(proxy='hahn',
                                       table_path=report_table,
                                       async_mode=False,
                                       upload_config=False)

def main():
    VH_LOG_PREFIX = "//home/logfeller/logs/vh-request-log/1d"
    cluster = clusters.yt.Hahn().env(yt_spec_defaults=dict(
                                    pool_trees=["physical"],
                                    tentative_pool_trees=["cloud"]
                                 ),
                                  templates=dict(
                                    tmp_root='//home/videolog/tmp',
                                    title='FrontendVhLoadCalc'
                                  ))
    for date in sorted(cluster.driver.list(VH_LOG_PREFIX))[-3:]:
        table_to_stat = '//tmp/vh_load_to_stat_' + date
        job = cluster.job()
        job.table(VH_LOG_PREFIX + "/" + date).map(VHLogParser()) \
                                             .groupby('ts', 'api').aggregate(count=na.sum('count'), fielddate=na.any('fielddate')) \
                                             .groupby('fielddate', 'api').aggregate(count=na.sum('count'), max_count=na.max('count')).put(table_to_stat)
        job.run()
        push_to_stat_new(table_to_stat, "Video.All/frontend_vh_load")

if __name__ == '__main__':
    main()
